/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.bpm.flownode;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.utils.ContractTypeConverter;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.contract.ContractDefinition;
import org.bonitasoft.engine.bpm.contract.ContractViolationException;
import org.bonitasoft.engine.bpm.flownode.FlowNodeExecutionException;
import org.bonitasoft.engine.bpm.flownode.UserTaskNotFoundException;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.server.api.resource.CommonResource;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.restlet.resource.Post;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserTaskExecutionResource
extends CommonResource {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)UserTaskExecutionResource.class.getName());
    static final String TASK_ID = "taskId";
    private static final String USER_PARAM = "user";
    private static final String ASSIGN = "assign";
    private final ProcessAPI processAPI;
    private final APISession apiSession;
    protected ContractTypeConverter typeConverterUtil = new ContractTypeConverter(ContractTypeConverter.ISO_8601_DATE_PATTERNS);

    public UserTaskExecutionResource(ProcessAPI processAPI, APISession apiSession) {
        this.processAPI = processAPI;
        this.apiSession = apiSession;
    }

    @Post(value="json")
    public void executeTask(Map<String, Serializable> inputs) throws UserTaskNotFoundException, FlowNodeExecutionException, FileNotFoundException, UpdateException {
        String userIdParameter = this.getRequestParameter(USER_PARAM);
        long userId = userIdParameter != null ? Long.parseLong(userIdParameter) : this.apiSession.getUserId();
        long taskId = this.getTaskIdParameter();
        boolean assign = Boolean.parseBoolean(this.getRequestParameter(ASSIGN));
        try {
            ContractDefinition taskContract = this.processAPI.getUserTaskContract(taskId);
            long maxSizeForTenant = this.getMaxSize();
            Map<String, Serializable> processedInputs = this.typeConverterUtil.getProcessedInput(taskContract, inputs, maxSizeForTenant);
            if (assign) {
                this.processAPI.assignAndExecuteUserTask(userId, taskId, processedInputs);
            } else {
                this.processAPI.executeUserTask(userId, taskId, processedInputs);
            }
            this.typeConverterUtil.deleteTemporaryFiles(inputs);
        }
        catch (FlowNodeExecutionException e) {
            String errorMessage = "Unable to execute the task with ID " + taskId;
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(errorMessage + " Error: " + e.getMessage());
            }
            throw new FlowNodeExecutionException(errorMessage + " (consult the logs for more information).");
        }
        catch (ContractViolationException e) {
            this.manageContractViolationException(e, "Cannot execute task.");
        }
    }

    protected long getMaxSize() {
        return PropertiesFactory.getConsoleProperties().getMaxSize();
    }

    protected long getTaskIdParameter() {
        String taskId = this.getAttribute(TASK_ID);
        if (taskId == null) {
            throw new APIException("Attribute 'taskId' is mandatory");
        }
        return Long.parseLong(taskId);
    }
}

