/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.deployer;

import org.bonitasoft.web.rest.model.applicationpage.ApplicationPageItem;
import org.bonitasoft.web.rest.server.framework.Deployer;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public class ApplicationPageDeployer
implements Deployer {
    private final DatastoreHasGet<ApplicationPageItem> getter;
    private final String attribute;

    public ApplicationPageDeployer(DatastoreHasGet<ApplicationPageItem> getter, String attribute) {
        this.getter = getter;
        this.attribute = attribute;
    }

    @Override
    public String getDeployedAttribute() {
        return this.attribute;
    }

    @Override
    public void deployIn(IItem item) {
        if (this.isDeployable(this.attribute, item)) {
            item.setDeploy(this.attribute, this.getApplicationPage(this.getApplicationPageId(item)));
        }
    }

    private APIID getApplicationPageId(IItem item) {
        return item.getAttributeValueAsAPIID(this.attribute);
    }

    private ApplicationPageItem getApplicationPage(APIID applicationPageId) {
        return this.getter.get(applicationPageId);
    }
}

