/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.deployer;

import org.bonitasoft.web.rest.model.identity.UserItem;
import org.bonitasoft.web.rest.server.framework.Deployer;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public class UserDeployer
implements Deployer {
    private final DatastoreHasGet<UserItem> getter;
    private final String attribute;

    public UserDeployer(DatastoreHasGet<UserItem> getter, String attribute) {
        this.getter = getter;
        this.attribute = attribute;
    }

    @Override
    public String getDeployedAttribute() {
        return this.attribute;
    }

    @Override
    public void deployIn(IItem item) {
        if (this.isDeployable(this.attribute, item)) {
            item.setDeploy(this.attribute, this.getUser(this.getUserId(item)));
        }
    }

    private APIID getUserId(IItem item) {
        return item.getAttributeValueAsAPIID(this.attribute);
    }

    private UserItem getUser(APIID userId) {
        return this.getter.get(userId);
    }
}

