/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.document.api.impl;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.document.ArchivedDocument;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentAttachmentException;
import org.bonitasoft.engine.bpm.document.DocumentException;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessDefinitionNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstanceNotFoundException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.NotFoundException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.document.ArchivedDocumentItem;
import org.bonitasoft.web.rest.model.document.DocumentItem;
import org.bonitasoft.web.rest.server.api.document.api.impl.DocumentUtil;

public class DocumentDatastore {
    private final APISession apiSession;
    public static final String CREATE_NEW_VERSION_DOCUMENT = "AddNewVersionDocument";
    public static final String CREATE_NEW_DOCUMENT = "AddNewDocument";

    public DocumentDatastore(APISession apiSession) {
        this.apiSession = apiSession;
    }

    public SearchResult<Document> searchDocuments(long userId, String viewType, SearchOptionsBuilder builder) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException, SearchException, NotFoundException {
        ProcessAPI processAPI = this.getProcessAPI();
        if ("ADMINISTRATOR".equals(viewType) || "USER".equals(viewType)) {
            return processAPI.searchDocuments(builder.done());
        }
        if ("TEAM_MANAGER".equals(viewType)) {
            return processAPI.searchDocuments(builder.done());
        }
        if ("PROCESS_OWNER".equals(viewType)) {
            return processAPI.searchDocumentsSupervisedBy(userId, builder.done());
        }
        throw new IllegalArgumentException("Invalid view type.");
    }

    public SearchResult<ArchivedDocument> searchArchivedDocuments(long userId, String viewType, SearchOptionsBuilder builder) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException, SearchException, NotFoundException {
        ProcessAPI processAPI = this.getProcessAPI();
        if ("ADMINISTRATOR".equals(viewType) || "USER".equals(viewType) || "TEAM_MANAGER".equals(viewType)) {
            return processAPI.searchArchivedDocuments(builder.done());
        }
        if ("PROCESS_OWNER".equals(viewType)) {
            return processAPI.searchArchivedDocumentsSupervisedBy(userId, builder.done());
        }
        throw new IllegalArgumentException("Invalid view type.");
    }

    public DocumentItem createDocument(long processInstanceId, String documentName, String documentCreationType, String path, BonitaHomeFolderAccessor tenantFolder) throws BonitaException, IOException, InvalidSessionException, RetrieveException {
        DocumentItem item = new DocumentItem();
        ProcessAPI processAPI = this.getProcessAPI();
        FileContent theSourceFile = tenantFolder.retrieveUploadedTempContent(path);
        try {
            DocumentItem documentItem;
            block13: {
                InputStream inputStream = theSourceFile.getInputStream();
                try {
                    long maxSize = PropertiesFactory.getConsoleProperties().getMaxSize();
                    if (theSourceFile.getSize() > maxSize * 0x100000L) {
                        String errorMessage = "This document is exceeded " + maxSize + "Mo";
                        throw new DocumentException(errorMessage);
                    }
                    byte[] fileContent = IOUtils.toByteArray((InputStream)inputStream);
                    String fileName = theSourceFile.getFileName();
                    String mimeType = theSourceFile.getMimeType();
                    if (CREATE_NEW_DOCUMENT.equals(documentCreationType)) {
                        document = processAPI.attachDocument(processInstanceId, documentName, fileName, mimeType, fileContent);
                        item = this.mapToDocumentItem(document);
                    } else if (CREATE_NEW_VERSION_DOCUMENT.equals(documentCreationType)) {
                        document = processAPI.attachNewDocumentVersion(processInstanceId, documentName, fileName, mimeType, fileContent);
                        item = this.mapToDocumentItem(document);
                    }
                    documentItem = item;
                    if (inputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return documentItem;
        }
        finally {
            tenantFolder.removeUploadedTempContent(path);
        }
    }

    protected ProcessAPI getProcessAPI() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getProcessAPI((APISession)this.apiSession);
    }

    public DocumentItem createDocumentFromUrl(long processInstanceId, String documentName, String documentCreationType, String path) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException, ProcessInstanceNotFoundException, DocumentAttachmentException, IOException, RetrieveException, ProcessDefinitionNotFoundException {
        DocumentItem item = new DocumentItem();
        ProcessAPI processAPI = this.getProcessAPI();
        String fileName = DocumentUtil.getFileNameFromUrl(path);
        String mimeType = DocumentUtil.getMimeTypeFromUrl(path);
        if (fileName != null && mimeType != null) {
            if (CREATE_NEW_DOCUMENT.equals(documentCreationType)) {
                Document document = processAPI.attachDocument(processInstanceId, documentName, fileName, mimeType, path);
                item = this.mapToDocumentItem(document);
            } else if (CREATE_NEW_VERSION_DOCUMENT.equals(documentCreationType)) {
                Document document = processAPI.attachNewDocumentVersion(processInstanceId, documentName, fileName, mimeType, path);
                item = this.mapToDocumentItem(document);
            }
        }
        return item;
    }

    public DocumentItem mapToDocumentItem(Document document) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException, ProcessDefinitionNotFoundException, RetrieveException {
        if (document == null) {
            throw new IllegalArgumentException("The document must be not null!");
        }
        DocumentItem item = new DocumentItem();
        ProcessAPI processAPI = this.getProcessAPI();
        String caseName = "";
        String processDisplayName = "";
        String version = "";
        try {
            ProcessInstance processInstance = processAPI.getProcessInstance(document.getProcessInstanceId());
            caseName = processInstance.getName();
            ProcessDeploymentInfo processDeploymentInfo = processAPI.getProcessDeploymentInfo(processInstance.getProcessDefinitionId());
            processDisplayName = processDeploymentInfo.getDisplayName();
            version = processDeploymentInfo.getVersion();
        }
        catch (ProcessInstanceNotFoundException e) {
            item = this.buildDocumentItem(caseName, processDisplayName, version, document);
            return item;
        }
        item = this.buildDocumentItem(caseName, processDisplayName, version, document);
        return item;
    }

    private DocumentItem buildDocumentItem(String caseName, String processDisplayName, String version, Document document) {
        DocumentItem item = new DocumentItem();
        item.setDocumentId(String.valueOf(document.getId()));
        item.setCaseId(String.valueOf(document.getProcessInstanceId()));
        item.setDocumentName(document.getName());
        item.setDocumentAuthor(document.getAuthor());
        item.setDocumentFileName(document.getContentFileName());
        item.setDocumentCreationDate(this.parseDate(document.getCreationDate()));
        item.setDocumentMIMEType(document.getContentMimeType());
        item.setDocumentHasContent(String.valueOf(document.hasContent()));
        item.setDocumentStorageId(document.getContentStorageId());
        item.setDocumentURL(document.getUrl());
        item.setProcessDisplayName(processDisplayName);
        item.setProcessVersion(version);
        item.setCaseName(caseName);
        return item;
    }

    public ArchivedDocumentItem mapToArchivedDocumentItem(ArchivedDocument document) throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException, RetrieveException, ProcessDefinitionNotFoundException {
        if (document == null) {
            throw new IllegalArgumentException("The document must be not null!");
        }
        ProcessAPI processAPI = this.getProcessAPI();
        ArchivedDocumentItem item = new ArchivedDocumentItem();
        String caseName = "";
        String processDisplayName = "";
        String version = "";
        try {
            List archivedCaseList = processAPI.getArchivedProcessInstances(document.getProcessInstanceId(), 0, 1);
            ArchivedProcessInstance processInstance = (ArchivedProcessInstance)archivedCaseList.get(0);
            caseName = processInstance.getName();
            ProcessDeploymentInfo processDeploymentInfo = processAPI.getProcessDeploymentInfo(processInstance.getProcessDefinitionId());
            processDisplayName = processDeploymentInfo.getDisplayName();
            version = processDeploymentInfo.getVersion();
        }
        catch (NotFoundException e) {
            item = this.buildArchivedDocumentItem(caseName, processDisplayName, version, document);
            return item;
        }
        item = this.buildArchivedDocumentItem(caseName, processDisplayName, version, document);
        return item;
    }

    private ArchivedDocumentItem buildArchivedDocumentItem(String caseName, String processDisplayName, String version, ArchivedDocument document) {
        ArchivedDocumentItem item = new ArchivedDocumentItem();
        item.setDocumentId(String.valueOf(document.getSourceObjectId()));
        item.setDocumentSourceObjectId(String.valueOf(document.getSourceObjectId()));
        item.setCaseId(String.valueOf(document.getProcessInstanceId()));
        item.setDocumentName(document.getName());
        item.setDocumentAuthor(document.getAuthor());
        item.setDocumentFileName(document.getContentFileName());
        item.setDocumentCreationDate(this.parseDate(document.getCreationDate()));
        item.setDocumentMIMEType(document.getContentMimeType());
        item.setDocumentHasContent(String.valueOf(document.hasContent()));
        item.setDocumentStorageId(document.getContentStorageId());
        item.setDocumentURL(document.getUrl());
        item.setProcessDisplayName(processDisplayName);
        item.setProcessVersion(version);
        item.setCaseName(caseName);
        item.setArchivedDate(this.parseDate(document.getArchiveDate()));
        return item;
    }

    private String parseDate(Date date) {
        String dateStr = null;
        if (date != null) {
            DateFormat time = DateFormat.getTimeInstance(2, Locale.ENGLISH);
            DateFormat df = DateFormat.getDateInstance(2, Locale.ENGLISH);
            dateStr = time.format(date) + ", " + df.format(date);
        }
        return dateStr;
    }
}

