/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.organization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.identity.UserMembershipCriterion;
import org.bonitasoft.web.rest.model.identity.MembershipItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.organization.GroupDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.MembershipDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.RoleDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.exception.APIFilterException;
import org.bonitasoft.web.rest.server.framework.exception.APIFilterMandatoryException;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIMembership
extends ConsoleAPI<MembershipItem>
implements APIHasAdd<MembershipItem>,
APIHasSearch<MembershipItem>,
APIHasDelete {
    @Override
    protected ItemDefinition defineItemDefinition() {
        return Definitions.get("membership");
    }

    @Override
    protected List<String> defineReadOnlyAttributes() {
        return Arrays.asList("assigned_by_user_id", "assigned_date");
    }

    @Override
    protected void fillDeploys(MembershipItem item, List<String> deploys) {
        if (this.isDeployable("user_id", deploys, item)) {
            item.setDeploy("user_id", new UserDatastore(this.getEngineSession()).get(item.getUserId()));
        }
        if (this.isDeployable("role_id", deploys, item)) {
            item.setDeploy("role_id", new RoleDatastore(this.getEngineSession()).get(item.getRoleId()));
        }
        if (this.isDeployable("group_id", deploys, item)) {
            item.setDeploy("group_id", new GroupDatastore(this.getEngineSession()).get(item.getGroupId()));
        }
        if (this.isDeployable("assigned_by_user_id", deploys, item)) {
            item.setDeploy("assigned_by_user_id", new UserDatastore(this.getEngineSession()).get(item.getAssignedByUserId()));
        }
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new MembershipDatastore(this.getEngineSession());
    }

    @Override
    public String defineDefaultSearchOrder() {
        return UserMembershipCriterion.ROLE_NAME_ASC.name();
    }

    @Override
    public ItemSearchResult<MembershipItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        if (filters.size() == 0) {
            throw new APIFilterMandatoryException("user_id");
        }
        if (filters.size() > 1 || !filters.containsKey("user_id")) {
            throw new APIFilterException("Cant search on filter other than user_id");
        }
        return super.search(page, resultsByPage, search, orders, filters);
    }
}

