/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.organization;

import java.util.Arrays;
import java.util.List;
import org.bonitasoft.engine.identity.RoleCriterion;
import org.bonitasoft.web.rest.model.identity.RoleItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.datastore.organization.RoleDatastore;
import org.bonitasoft.web.rest.server.datastore.organization.UserDatastore;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIRole
extends ConsoleAPI<RoleItem>
implements APIHasGet<RoleItem>,
APIHasSearch<RoleItem>,
APIHasUpdate<RoleItem>,
APIHasAdd<RoleItem>,
APIHasDelete {
    @Override
    protected ItemDefinition defineItemDefinition() {
        return Definitions.get("role");
    }

    @Override
    protected void fillDeploys(RoleItem item, List<String> deploys) {
        if (this.isDeployable("created_by_user_id", deploys, item)) {
            item.setDeploy("created_by_user_id", new UserDatastore(this.getEngineSession()).get(item.getCreatedByUserId()));
        }
    }

    @Override
    protected void fillCounters(RoleItem item, List<String> counters) {
        if (counters.contains("number_of_users")) {
            item.setAttribute("number_of_users", ((RoleDatastore)this.defineDefaultDatastore()).getNumberOfUsers(item.getId()));
        }
    }

    @Override
    protected List<String> defineReadOnlyAttributes() {
        return Arrays.asList("created_by_user_id", "creation_date", "last_update_date");
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return new RoleDatastore(this.getEngineSession());
    }

    @Override
    public String defineDefaultSearchOrder() {
        return RoleCriterion.DISPLAY_NAME_ASC.name();
    }
}

