/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.organization.password.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.AbstractStringValidator;

public class RobustnessPasswordValidator
extends AbstractStringValidator {
    @Override
    protected void _check(String password) {
        AbstractI18n.LOCALE Locale2 = AbstractI18n.stringToLocale(this.locale);
        String regex = "[0-9]";
        int numberMinOccurences = 3;
        if (this.numberOfOccurenceOfRegex(regex, password) < numberMinOccurences) {
            this.addError(AbstractI18n.t_("Password must contain at least %number% digits", Locale2, new Arg("number", numberMinOccurences)));
        }
        regex = "[a-z]";
        numberMinOccurences = 2;
        if (this.numberOfOccurenceOfRegex(regex, password) < numberMinOccurences) {
            this.addError(AbstractI18n.t_("Password must contain at least %number% lower case characters", Locale2, new Arg("number", numberMinOccurences)));
        }
        regex = "[A-Z]";
        numberMinOccurences = 2;
        if (this.numberOfOccurenceOfRegex(regex, password) < numberMinOccurences) {
            this.addError(AbstractI18n.t_("Password must contain at least %number% upper case characters", Locale2, new Arg("number", numberMinOccurences)));
        }
        regex = "[~@#\\^\\$&\\*\\(\\)-T_\\+=\\[\\]\\{\\}\\|\\,\\.\\?]";
        numberMinOccurences = 2;
        if (this.numberOfOccurenceOfRegex(regex, password) < numberMinOccurences) {
            this.addError(AbstractI18n.t_("Password must contain at least %number% special characters", Locale2, new Arg("number", numberMinOccurences)));
        }
        int minimalLength = 10;
        if (password.length() < minimalLength) {
            this.addError(AbstractI18n.t_("Password must be at least %number% characters long", Locale2, new Arg("number", minimalLength)));
        }
    }

    private int numberOfOccurenceOfRegex(String regex, String password) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(password);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        return count;
    }
}

