/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.page;

import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.preferences.constants.WebBonitaConstantsUtils;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.portal.page.PageDefinition;
import org.bonitasoft.web.rest.model.portal.page.PageItem;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.deployer.DeployerFactory;
import org.bonitasoft.web.rest.server.datastore.page.PageDatastore;
import org.bonitasoft.web.rest.server.datastore.page.PageDatastoreFactory;
import org.bonitasoft.web.rest.server.framework.api.APIHasAdd;
import org.bonitasoft.web.rest.server.framework.api.APIHasDelete;
import org.bonitasoft.web.rest.server.framework.api.APIHasGet;
import org.bonitasoft.web.rest.server.framework.api.APIHasSearch;
import org.bonitasoft.web.rest.server.framework.api.APIHasUpdate;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.ItemDefinition;

public class APIPage
extends ConsoleAPI<PageItem>
implements APIHasGet<PageItem>,
APIHasSearch<PageItem>,
APIHasAdd<PageItem>,
APIHasUpdate<PageItem>,
APIHasDelete {
    @Override
    protected ItemDefinition<PageItem> defineItemDefinition() {
        return PageDefinition.get();
    }

    @Override
    protected Datastore defineDefaultDatastore() {
        return this.getPageDatastore();
    }

    @Override
    public PageItem get(APIID id) {
        return this.getPageDatastore().get(id);
    }

    @Override
    @Deprecated(since="9.0.0")
    public PageItem add(PageItem item) {
        return this.getPageDatastore().add(item);
    }

    @Override
    @Deprecated(since="9.0.0")
    public PageItem update(APIID id, Map<String, String> attributes) {
        return this.getPageDatastore().update(id, (Map)attributes);
    }

    @Override
    public void delete(List<APIID> ids) {
        this.getPageDatastore().delete(ids);
    }

    @Override
    public ItemSearchResult<PageItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return this.getPageDatastore().search(page, resultsByPage, search, orders, filters);
    }

    @Override
    protected void fillDeploys(PageItem item, List<String> deploys) {
        this.addDeployer(this.getDeployerFactory().createUserDeployer("createdBy"));
        this.addDeployer(this.getDeployerFactory().createUserDeployer("updatedBy"));
        super.fillDeploys(item, deploys);
    }

    protected DeployerFactory getDeployerFactory() {
        return new DeployerFactory(this.getEngineSession());
    }

    @Override
    public String defineDefaultSearchOrder() {
        return "urlToken";
    }

    private PageDatastore getPageDatastore() {
        PageAPI pageAPI;
        try {
            pageAPI = TenantAPIAccessor.getCustomPageAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
        WebBonitaConstantsUtils constants = WebBonitaConstantsUtils.getTenantInstance();
        PageDatastoreFactory pageDatastoreFactory = new PageDatastoreFactory();
        return pageDatastoreFactory.create(this.getEngineSession(), constants, pageAPI);
    }
}

