/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.api.system;

import java.util.Collections;
import org.bonitasoft.console.common.server.auth.AuthenticationManagerProperties;
import org.bonitasoft.web.rest.server.api.ConsoleAPI;
import org.bonitasoft.web.rest.server.api.system.BonitaVersion;
import org.bonitasoft.web.rest.server.api.system.VersionFile;
import org.bonitasoft.web.toolkit.client.common.json.JSonSerializer;
import org.bonitasoft.web.toolkit.client.common.session.SessionDefinition;
import org.bonitasoft.web.toolkit.client.common.session.SessionItem;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Definitions;

public class APISession
extends ConsoleAPI<SessionItem> {
    final BonitaVersion bonitaVersion = new BonitaVersion(new VersionFile());

    protected SessionDefinition defineItemDefinition() {
        return (SessionDefinition)Definitions.get("session");
    }

    @Override
    public SessionItem get(APIID unusedId) {
        org.bonitasoft.engine.session.APISession apiSession = this.getEngineSession();
        SessionItem session = new SessionItem();
        if (apiSession != null) {
            session.setAttribute("session_id", String.valueOf(apiSession.getId()));
            session.setAttribute("user_id", String.valueOf(apiSession.getUserId()));
            session.setAttribute("user_name", apiSession.getUserName());
            session.setAttribute("is_technical_user", String.valueOf(apiSession.isTechnicalUser()));
            session.setAttribute("is_guest_user", String.valueOf(this.isGuestUser(apiSession.getUserName())));
            session.setAttribute("version", this.getVersion());
            session.setAttribute("branding_version", this.getBrandingVersion());
            session.setAttribute("branding_version_with_date", this.getBrandingVersionWithDate());
            session.setAttribute("copyright", this.getCopyright());
            session.setAttribute("conf", this.getLogoutConfiguration(apiSession));
        }
        return session;
    }

    protected boolean isGuestUser(String loggedInUsername) {
        return false;
    }

    protected AuthenticationManagerProperties getAuthenticationManagerProperties() {
        return AuthenticationManagerProperties.getProperties();
    }

    public String getLogoutConfiguration(org.bonitasoft.engine.session.APISession apiSession) {
        if (!apiSession.isTechnicalUser() && this.isLogoutDisabled()) {
            return JSonSerializer.serialize(Collections.singletonList("logout.link.hidden"));
        }
        return JSonSerializer.serialize(Collections.emptyList());
    }

    protected boolean isLogoutDisabled() {
        return this.getAuthenticationManagerProperties().isLogoutDisabled();
    }

    public String getVersion() {
        return this.bonitaVersion.getVersion();
    }

    public String getBrandingVersion() {
        return this.bonitaVersion.getBrandingVersion();
    }

    public String getBrandingVersionWithDate() {
        return this.bonitaVersion.getBrandingVersionWithUpdate();
    }

    public String getCopyright() {
        return this.bonitaVersion.getCopyright();
    }
}

