/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.server.framework.api.Datastore;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.data.item.IItem;

public abstract class CommonDatastore<C extends IItem, E extends Serializable>
extends Datastore {
    private APISession engineSession;

    public CommonDatastore(APISession engineSession) {
        this.engineSession = engineSession;
    }

    protected final APISession getEngineSession() {
        return this.engineSession;
    }

    protected void addStringFilterToSearchBuilder(Map<String, String> filters, SearchOptionsBuilder builder, String filterName, String engineAttributeName) {
        String filterValue;
        if (filters != null && filters.containsKey(filterName) && (filterValue = filters.get(filterName)) != null) {
            if (filterValue.startsWith(">")) {
                builder.greaterThan(engineAttributeName, (Serializable)((Object)this.getFilterValueWithoutFirstCharacter(filterValue)));
            } else if (filterValue.startsWith("<")) {
                builder.lessThan(engineAttributeName, (Serializable)((Object)this.getFilterValueWithoutFirstCharacter(filterValue)));
            } else {
                builder.filter(engineAttributeName, (Serializable)((Object)filterValue));
            }
        }
    }

    private String getFilterValueWithoutFirstCharacter(String filterValue) {
        return filterValue.substring(1).trim();
    }

    protected void addLongFilterToSearchBuilder(Map<String, String> filters, SearchOptionsBuilder builder, String filterName, String engineAttributeName) {
        String filterValue;
        if (filters != null && filters.containsKey(filterName) && (filterValue = filters.get(filterName)) != null) {
            if (filterValue.startsWith(">")) {
                builder.greaterThan(engineAttributeName, (Serializable)Long.valueOf(this.getFilterValueWithoutFirstCharacter(filterValue)));
            } else if (filterValue.startsWith("<")) {
                builder.lessThan(engineAttributeName, (Serializable)Long.valueOf(this.getFilterValueWithoutFirstCharacter(filterValue)));
            } else {
                builder.filter(engineAttributeName, (Serializable)Long.valueOf(filterValue));
            }
        }
    }

    protected abstract C convertEngineToConsoleItem(E var1);

    protected ItemSearchResult<C> convertEngineToConsoleSearch(int page, int resultsByPage, SearchResult<E> engineSearchResults) {
        return new ItemSearchResult<C>(page, resultsByPage, engineSearchResults.getCount(), this.convertEngineToConsoleItemsList(engineSearchResults.getResult()));
    }

    protected List<C> convertEngineToConsoleItemsList(List<E> engineSearchResults) {
        ArrayList<C> consoleSearchResults = new ArrayList<C>();
        for (Serializable engineItem : engineSearchResults) {
            consoleSearchResults.add(this.convertEngineToConsoleItem(engineItem));
        }
        return consoleSearchResults;
    }
}

