/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.application;

import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.api.ApplicationAPI;
import org.bonitasoft.engine.api.PageAPI;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.business.application.ApplicationCreator;
import org.bonitasoft.engine.business.application.ApplicationNotFoundException;
import org.bonitasoft.engine.business.application.ApplicationPage;
import org.bonitasoft.engine.business.application.ApplicationUpdater;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.SearchException;
import org.bonitasoft.engine.page.Page;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.application.ApplicationItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.application.ApplicationFilterCreator;
import org.bonitasoft.web.rest.server.datastore.application.ApplicationItemConverter;
import org.bonitasoft.web.rest.server.datastore.application.ApplicationSearchDescriptorConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ApplicationDataStore
extends CommonDatastore<ApplicationItem, Application>
implements DatastoreHasAdd<ApplicationItem>,
DatastoreHasUpdate<ApplicationItem>,
DatastoreHasGet<ApplicationItem>,
DatastoreHasSearch<ApplicationItem>,
DatastoreHasDelete {
    private final ApplicationAPI applicationAPI;
    private final ApplicationItemConverter converter;
    private final PageAPI pageAPI;
    private static final String CUSTOMPAGE_HOME = "custompage_home";

    public ApplicationDataStore(APISession engineSession, ApplicationAPI applicationAPI, PageAPI pageAPI, ApplicationItemConverter converter) {
        super(engineSession);
        this.applicationAPI = applicationAPI;
        this.pageAPI = pageAPI;
        this.converter = converter;
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            for (APIID id : ids) {
                this.applicationAPI.deleteApplication(id.toLong().longValue());
            }
        }
        catch (BonitaException e) {
            if (e.getCause() instanceof ApplicationNotFoundException) {
                throw new APIItemNotFoundException("application");
            }
            throw new APIException(e);
        }
    }

    @Override
    public ApplicationItem get(APIID id) {
        try {
            Application application = this.applicationAPI.getApplication(id.toLong().longValue());
            return this.converter.toApplicationItem(application);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationItem add(ApplicationItem item) {
        try {
            Page homePageDef = this.pageAPI.getPageByName(CUSTOMPAGE_HOME);
            ApplicationCreator creator = this.converter.toApplicationCreator(item);
            Application application = this.applicationAPI.createApplication(creator);
            ApplicationPage appHomePage = this.applicationAPI.createApplicationPage(application.getId(), homePageDef.getId(), "home");
            this.applicationAPI.setApplicationHomePage(application.getId(), appHomePage.getId());
            return this.converter.toApplicationItem(application);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    @Deprecated(since="9.0.0")
    public ApplicationItem update(APIID id, Map<String, String> attributes) {
        try {
            ApplicationUpdater applicationUpdater = this.converter.toApplicationUpdater(attributes);
            Application application = this.applicationAPI.updateApplication(id.toLong().longValue(), applicationUpdater);
            return this.converter.toApplicationItem(application);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<ApplicationItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsCreator creator = this.makeSearchOptionCreator(page, resultsByPage, search, orders, filters);
        try {
            SearchResult<Application> searchResult = this.runSearch(creator);
            return new ItemSearchResult<ApplicationItem>(page, resultsByPage, searchResult.getCount(), this.convertEngineToConsoleItemsList(searchResult.getResult()));
        }
        catch (SearchException e) {
            throw new APIException(e);
        }
    }

    protected SearchOptionsCreator makeSearchOptionCreator(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, this.getSearchDescriptorConverter()), new Filters(filters, new ApplicationFilterCreator(this.getSearchDescriptorConverter())));
    }

    protected SearchResult<Application> runSearch(SearchOptionsCreator creator) throws SearchException {
        return this.applicationAPI.searchApplications(creator.create());
    }

    protected ApplicationSearchDescriptorConverter getSearchDescriptorConverter() {
        return new ApplicationSearchDescriptorConverter();
    }

    @Override
    protected ApplicationItem convertEngineToConsoleItem(Application item) {
        return new ApplicationItemConverter(new BonitaHomeFolderAccessor()).toApplicationItem(item);
    }
}

