/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.application;

import java.util.Map;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.IconDescriptor;
import org.bonitasoft.engine.business.application.Application;
import org.bonitasoft.engine.business.application.ApplicationCreator;
import org.bonitasoft.engine.business.application.ApplicationUpdater;
import org.bonitasoft.web.rest.model.application.ApplicationItem;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;

public class ApplicationItemConverter {
    protected BonitaHomeFolderAccessor bonitaHomeFolderAccessor;

    public ApplicationItemConverter(BonitaHomeFolderAccessor bonitaHomeFolderAccessor) {
        this.bonitaHomeFolderAccessor = bonitaHomeFolderAccessor;
    }

    public ApplicationItem toApplicationItem(Application application) {
        ApplicationItem item = new ApplicationItem();
        item.setId(application.getId());
        item.setToken(application.getToken());
        item.setDisplayName(application.getDisplayName());
        item.setVersion(application.getVersion());
        item.setDescription(application.getDescription());
        item.setIcon((String)(application.hasIcon() ? "../API/applicationIcon/" + application.getId() + "?t=" + application.getLastUpdateDate().getTime() : ""));
        item.setCreationDate(Long.toString(application.getCreationDate().getTime()));
        item.setCreatedBy(application.getCreatedBy());
        item.setLastUpdateDate(Long.toString(application.getLastUpdateDate().getTime()));
        item.setUpdatedBy(application.getUpdatedBy());
        item.setState(application.getState());
        item.setVisibility(application.getVisibility().name());
        item.setEditable(application.isEditable());
        if (application.getProfileId() != null) {
            item.setProfileId(application.getProfileId());
        } else {
            item.setProfileId(-1L);
        }
        if (application.getHomePageId() != null) {
            item.setHomePageId(application.getHomePageId());
        } else {
            item.setHomePageId(-1L);
        }
        if (application.getLayoutId() != null) {
            item.setLayoutId(application.getLayoutId());
        } else {
            item.setLayoutId(-1L);
        }
        if (application.getThemeId() != null) {
            item.setThemeId(application.getThemeId());
        } else {
            item.setThemeId(-1L);
        }
        return item;
    }

    public ApplicationCreator toApplicationCreator(ApplicationItem appItem) {
        ApplicationCreator creator = new ApplicationCreator(appItem.getToken(), appItem.getDisplayName(), appItem.getVersion());
        creator.setDescription(appItem.getDescription());
        creator.setProfileId(appItem.getProfileId().toLong());
        return creator;
    }

    public ApplicationUpdater toApplicationUpdater(Map<String, String> attributes) {
        ApplicationUpdater applicationUpdater = this.getApplicationUpdater();
        if (attributes.containsKey("token")) {
            applicationUpdater.setToken(attributes.get("token"));
        }
        if (attributes.containsKey("displayName")) {
            applicationUpdater.setDisplayName(attributes.get("displayName"));
        }
        if (attributes.containsKey("description")) {
            applicationUpdater.setDescription(attributes.get("description"));
        }
        if (attributes.containsKey("profileId")) {
            applicationUpdater.setProfileId(Long.valueOf(Long.parseLong(attributes.get("profileId"))));
        }
        if (attributes.containsKey("homePageId")) {
            Long homePageId = Long.parseLong(attributes.get("homePageId"));
            if (homePageId == -1L) {
                homePageId = null;
            }
            applicationUpdater.setHomePageId(homePageId);
        }
        if (attributes.containsKey("state")) {
            applicationUpdater.setState(attributes.get("state"));
        }
        if (attributes.containsKey("version")) {
            applicationUpdater.setVersion(attributes.get("version"));
        }
        if (!MapUtil.isBlank(attributes, "icon") && !attributes.get("icon").startsWith("../API/applicationIcon/")) {
            IconDescriptor iconDescriptor = this.bonitaHomeFolderAccessor.getIconFromFileSystem(attributes.get("icon"));
            applicationUpdater.setIcon(iconDescriptor.getFilename(), iconDescriptor.getContent());
        }
        return applicationUpdater;
    }

    protected ApplicationUpdater getApplicationUpdater() {
        return new ApplicationUpdater();
    }
}

