/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.cases;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstanceNotFoundException;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.cases.ArchivedCaseItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ArchivedCaseDatastore
extends CommonDatastore<ArchivedCaseItem, ArchivedProcessInstance>
implements DatastoreHasGet<ArchivedCaseItem>,
DatastoreHasSearch<ArchivedCaseItem>,
DatastoreHasDelete {
    public ArchivedCaseDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    protected ArchivedCaseItem convertEngineToConsoleItem(ArchivedProcessInstance item) {
        ArchivedCaseItem result = new ArchivedCaseItem();
        result.setId(item.getId());
        result.setLastUpdateDate(item.getLastUpdate());
        result.setState(item.getState());
        result.setStartDate(item.getStartDate());
        result.setEndDate(item.getEndDate());
        result.setProcessId(item.getProcessDefinitionId());
        result.setArchivedDate(item.getArchiveDate());
        result.setSourceObjectId(item.getSourceObjectId());
        result.setRootCaseId(item.getRootProcessInstanceId());
        result.setStartedByUserId(item.getStartedBy());
        result.setStartedBySubstituteUserId(item.getStartedBySubstitute());
        result.setSearchIndex1Label(item.getStringIndexLabel(1));
        result.setSearchIndex2Label(item.getStringIndexLabel(2));
        result.setSearchIndex3Label(item.getStringIndexLabel(3));
        result.setSearchIndex4Label(item.getStringIndexLabel(4));
        result.setSearchIndex5Label(item.getStringIndexLabel(5));
        result.setSearchIndex1Value(item.getStringIndexValue(1));
        result.setSearchIndex2Value(item.getStringIndexValue(2));
        result.setSearchIndex3Value(item.getStringIndexValue(3));
        result.setSearchIndex4Value(item.getStringIndexValue(4));
        result.setSearchIndex5Value(item.getStringIndexValue(5));
        return result;
    }

    @Override
    public ItemSearchResult<ArchivedCaseItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsBuilder builder = this.buildSearchOptions(page, resultsByPage, search, orders, filters);
        SearchResult<ArchivedProcessInstance> searchResult = this.runSearch(filters, builder);
        return new ItemSearchResult<ArchivedCaseItem>(page, resultsByPage, searchResult.getCount(), this.convertEngineToConsoleItemsList(searchResult.getResult()));
    }

    protected SearchOptionsBuilder buildSearchOptions(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
        this.addStringFilterToSearchBuilder(filters, builder, "name", "name");
        this.addLongFilterToSearchBuilder(filters, builder, "processDefinitionId", "processDefinitionId");
        this.addLongFilterToSearchBuilder(filters, builder, "started_by", "startedBy");
        this.addLongFilterToSearchBuilder(filters, builder, "sourceObjectId", "sourceObjectId");
        this.addCallerFilterToSearchBuilderIfNecessary(filters, builder);
        return builder;
    }

    void addCallerFilterToSearchBuilderIfNecessary(Map<String, String> filters, SearchOptionsBuilder builder) {
        if (!filters.containsKey("caller")) {
            builder.filter("callerId", (Serializable)Integer.valueOf(-1));
        } else if (!"any".equalsIgnoreCase(filters.get("caller"))) {
            builder.filter("callerId", (Serializable)MapUtil.getValueAsLong(filters, "caller"));
        }
    }

    @Override
    protected void addLongFilterToSearchBuilder(Map<String, String> filters, SearchOptionsBuilder builder, String filterName, String engineAttributeName) {
        super.addLongFilterToSearchBuilder(filters, builder, filterName, engineAttributeName);
    }

    protected SearchResult<ArchivedProcessInstance> runSearch(Map<String, String> filters, SearchOptionsBuilder builder) {
        try {
            ProcessAPI processAPI = this.getProcessApi();
            if (filters.containsKey("user_id")) {
                return processAPI.searchArchivedProcessInstancesInvolvingUser(MapUtil.getValueAsLong(filters, "user_id").longValue(), builder.done());
            }
            if (filters.containsKey("supervisor_id")) {
                return processAPI.searchArchivedProcessInstancesSupervisedBy(MapUtil.getValueAsLong(filters, "supervisor_id").longValue(), builder.done());
            }
            if (filters.containsKey("caller")) {
                builder.filter("stateId", (Serializable)Integer.valueOf(ProcessInstanceState.COMPLETED.getId()));
                return processAPI.searchArchivedProcessInstancesInAllStates(builder.done());
            }
            return processAPI.searchArchivedProcessInstances(builder.done());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ArchivedCaseItem get(APIID id) {
        try {
            return this.convertEngineToConsoleItem(this.getProcessApi().getArchivedProcessInstance(id.toLong().longValue()));
        }
        catch (ArchivedProcessInstanceNotFoundException e) {
            throw new APIItemNotFoundException("archivedcases", id);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public ArchivedCaseItem getUsingSourceObjectId(APIID id) {
        try {
            return this.convertEngineToConsoleItem(this.getProcessApi().getFinalArchivedProcessInstance(id.toLong().longValue()));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            ProcessAPI processAPI = this.getProcessApi();
            ArrayList<Long> toDeleteIds = new ArrayList<Long>();
            for (APIID apiId : ids) {
                ArchivedProcessInstance archivedProcessInstance = processAPI.getArchivedProcessInstance(apiId.toLong().longValue());
                toDeleteIds.add(archivedProcessInstance.getSourceObjectId());
            }
            processAPI.deleteArchivedProcessInstancesInAllStates(toDeleteIds);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public ProcessAPI getProcessApi() throws BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
    }
}

