/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.cases;

import java.util.ArrayList;
import java.util.Map;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.comment.ArchivedComment;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.Order;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.cases.ArchivedCommentItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;

public class ArchivedCommentDatastore
extends CommonDatastore<ArchivedCommentItem, ArchivedComment>
implements DatastoreHasSearch<ArchivedCommentItem> {
    private static final String[][] SORTABLE_FIELDS_LUT = new String[][]{{"postDate", "postdate"}};

    public ArchivedCommentDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    public ItemSearchResult<ArchivedCommentItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, "", search);
            this.adjustSearchBuilder(filters, builder);
            if (orders != null && !orders.isEmpty()) {
                String[] sort = orders.split(" ");
                for (int i = 0; i < SORTABLE_FIELDS_LUT.length; ++i) {
                    if (!sort[0].equals(SORTABLE_FIELDS_LUT[i][0])) continue;
                    builder.sort(SORTABLE_FIELDS_LUT[i][1], Order.valueOf((String)sort[1]));
                }
            }
            SearchResult result = TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession()).searchArchivedComments(builder.done());
            ArrayList<ArchivedCommentItem> archivedCommentList = new ArrayList<ArchivedCommentItem>();
            for (ArchivedComment item : result.getResult()) {
                ArchivedCommentItem resultArchivedCommentItem = this.convertEngineToConsoleItem(item);
                archivedCommentList.add(resultArchivedCommentItem);
            }
            return new ItemSearchResult<ArchivedCommentItem>(page, resultsByPage, result.getCount(), archivedCommentList);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private void adjustSearchBuilder(Map<String, String> filters, SearchOptionsBuilder builder) {
        this.addStringFilterToSearchBuilder(filters, builder, "processInstanceId", "processInstanceId");
    }

    @Override
    protected ArchivedCommentItem convertEngineToConsoleItem(ArchivedComment item) {
        if (item == null) {
            return null;
        }
        ArchivedCommentItem consoleItem = new ArchivedCommentItem();
        consoleItem.setId(item.getId());
        consoleItem.setUserId(item.getUserId());
        consoleItem.setProcessInstanceId(item.getProcessInstanceId());
        consoleItem.setPostDate(item.getPostDate());
        consoleItem.setArchivedDate(item.getArchiveDate());
        consoleItem.setContent(item.getContent());
        return consoleItem;
    }
}

