/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.cases;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.console.common.server.preferences.properties.PropertiesFactory;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.DocumentException;
import org.bonitasoft.engine.bpm.document.DocumentNotFoundException;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.io.FileContent;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.cases.CaseDocumentItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseDocumentFilterCreator;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseDocumentItemConverter;
import org.bonitasoft.web.rest.server.datastore.bpm.cases.CaseDocumentSearchAttributeConverter;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class CaseDocumentDatastore
extends CommonDatastore<CaseDocumentItem, Document>
implements DatastoreHasAdd<CaseDocumentItem>,
DatastoreHasGet<CaseDocumentItem>,
DatastoreHasUpdate<CaseDocumentItem>,
DatastoreHasDelete {
    protected final ProcessAPI processAPI;
    final long maxSizeForTenant;
    final FileTypeMap mimetypesFileTypeMap;
    final BonitaHomeFolderAccessor tenantFolder;
    protected SearchOptionsCreator searchOptionsCreator;

    public CaseDocumentDatastore(APISession engineSession, ProcessAPI processAPI, BonitaHomeFolderAccessor tenantFolder) {
        super(engineSession);
        this.processAPI = processAPI;
        this.tenantFolder = tenantFolder;
        this.maxSizeForTenant = PropertiesFactory.getConsoleProperties().getMaxSize();
        this.mimetypesFileTypeMap = new MimetypesFileTypeMap();
    }

    @Override
    public CaseDocumentItem get(APIID id) {
        try {
            Document documentItem = this.processAPI.getDocument(id.toLong().longValue());
            return this.convertEngineToConsoleItem(documentItem);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public CaseDocumentItem add(CaseDocumentItem item) {
        long caseId = -1L;
        int index = -1;
        String documentDescription = "";
        DocumentValue documentValue = null;
        try {
            if (item.getAttributeValue("caseId") != null) {
                caseId = Long.valueOf(item.getAttributeValue("caseId"));
            }
        }
        catch (NumberFormatException e) {
            throw new APIException("Error while attaching a new document. Request with bad case id value.");
        }
        String documentName = item.getAttributeValue("name");
        String uploadPath = item.getAttributeValue("file");
        String urlPath = item.getAttributeValue("url");
        if (item.getAttributeValue("description") != null) {
            documentDescription = item.getAttributeValue("description");
        }
        if (item.getAttributeValue("index") != null) {
            index = Integer.parseInt(item.getAttributeValue("index"));
        }
        try {
            if (caseId != -1L && documentName != null) {
                documentValue = urlPath != null ? this.buildDocumentValueFromUrl(urlPath, -1) : this.buildDocumentValueFromUploadPath(uploadPath, index, item.getFileName());
                Document document = this.processAPI.addDocument(caseId, documentName, documentDescription, documentValue);
                CaseDocumentItem caseDocumentItem = this.convertEngineToConsoleItem(document);
                return caseDocumentItem;
            }
            try {
                throw new APIException("Error while attaching a new document. Request with bad param value.");
            }
            catch (IOException | BonitaException e) {
                throw new APIException(e);
            }
        }
        finally {
            if (urlPath == null) {
                this.tenantFolder.removeUploadedTempContent(uploadPath);
            }
        }
    }

    @Override
    public CaseDocumentItem update(APIID id, Map<String, String> attributes) {
        DocumentValue documentValue = null;
        try {
            if (attributes.containsKey("file") || attributes.containsKey("url")) {
                if (attributes.containsKey("url")) {
                    String urlPath = attributes.get("url");
                    documentValue = this.buildDocumentValueFromUrl(urlPath, -1);
                } else {
                    String urlPath = attributes.get("file");
                    documentValue = this.buildDocumentValueFromUploadPath(urlPath, -1, attributes.get("fileName"));
                }
                Document document = this.processAPI.updateDocument(id.toLong().longValue(), documentValue);
                CaseDocumentItem caseDocumentItem = this.convertEngineToConsoleItem(document);
                return caseDocumentItem;
            }
            try {
                throw new APIException("Error while attaching a new document. Request with bad param value.");
            }
            catch (IOException | BonitaException e) {
                throw new APIException(e);
            }
        }
        finally {
            if (attributes.containsKey("file")) {
                this.tenantFolder.removeUploadedTempContent(attributes.get("file"));
            }
        }
    }

    protected DocumentValue buildDocumentValueFromUploadPath(String uploadKey, int index, String fileName) throws IOException {
        String mimeType = null;
        byte[] fileContent = null;
        if (uploadKey != null) {
            try {
                FileContent theSourceFile = this.tenantFolder.retrieveUploadedTempContent(uploadKey);
                if (theSourceFile.getSize() > this.maxSizeForTenant * 0x100000L) {
                    String errorMessage = "This document is exceeded " + this.maxSizeForTenant + "Mb";
                    throw new DocumentException(errorMessage);
                }
                try (InputStream inputStream = theSourceFile.getInputStream();){
                    fileContent = IOUtils.toByteArray((InputStream)inputStream);
                    if (StringUtil.isBlank(fileName)) {
                        fileName = theSourceFile.getFileName();
                    }
                    mimeType = theSourceFile.getMimeType();
                }
            }
            catch (BonitaException e) {
                throw new FileNotFoundException("Cannot find " + uploadKey + " in the tenant temp directory.");
            }
        }
        DocumentValue documentValue = new DocumentValue(fileContent, mimeType, fileName);
        if (index != -1) {
            documentValue.setIndex(index);
        }
        return documentValue;
    }

    protected DocumentValue buildDocumentValueFromUrl(String urlPath, int index) {
        DocumentValue documentValue = new DocumentValue(urlPath);
        if (index != -1) {
            documentValue.setIndex(index);
        }
        return documentValue;
    }

    public ItemSearchResult<CaseDocumentItem> search(int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        return this.searchDocument(page, resultsByPage, search, filters, orders);
    }

    protected ItemSearchResult<CaseDocumentItem> searchDocument(int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        try {
            APIID supervisorAPIID = APIID.makeAPIID(filters.get("supervisor_id"));
            if (supervisorAPIID != null) {
                filters.remove("supervisor_id");
            }
            this.searchOptionsCreator = this.buildSearchOptionCreator(page, resultsByPage, search, filters, orders);
            SearchResult engineSearchResults = supervisorAPIID != null && supervisorAPIID.isValidLongID() ? this.processAPI.searchDocumentsSupervisedBy(supervisorAPIID.toLong().longValue(), this.searchOptionsCreator.create()) : this.processAPI.searchDocuments(this.searchOptionsCreator.create());
            return new ItemSearchResult<CaseDocumentItem>(page, resultsByPage, engineSearchResults.getCount(), this.convertEngineToConsoleItem(engineSearchResults.getResult()));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    protected SearchOptionsCreator buildSearchOptionCreator(int page, int resultsByPage, String search, Map<String, String> filters, String orders) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, this.getDocumentSearchAttributeConverter()), new Filters(filters, new CaseDocumentFilterCreator(this.getDocumentSearchAttributeConverter())));
    }

    private CaseDocumentSearchAttributeConverter getDocumentSearchAttributeConverter() {
        return new CaseDocumentSearchAttributeConverter();
    }

    @Override
    public void delete(List<APIID> ids) {
        if (ids != null) {
            try {
                for (APIID id : ids) {
                    this.processAPI.removeDocument(id.toLong().longValue());
                }
            }
            catch (DocumentNotFoundException e) {
                throw new APIException("Error while deleting a document. Document not found");
            }
            catch (DeletionException e) {
                throw new APIException(e);
            }
        } else {
            throw new APIException("Error while deleting a document. Document id not specified in the request");
        }
    }

    @Override
    protected CaseDocumentItem convertEngineToConsoleItem(Document item) {
        if (item != null) {
            return new CaseDocumentItemConverter().convert(item);
        }
        return null;
    }

    @Override
    private List<CaseDocumentItem> convertEngineToConsoleItem(List<Document> result) {
        if (result != null) {
            return new CaseDocumentItemConverter().convert(result);
        }
        return null;
    }
}

