/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.flownode;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.bpm.data.DataInstance;
import org.bonitasoft.engine.bpm.flownode.ActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ActivityInstanceNotFoundException;
import org.bonitasoft.engine.bpm.flownode.FlowNodeInstance;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.flownode.ActivityItem;
import org.bonitasoft.web.rest.model.bpm.flownode.FlowNodeItem;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.AbstractFlowNodeDatastore;
import org.bonitasoft.web.rest.server.datastore.bpm.flownode.FlowNodeDatastore;
import org.bonitasoft.web.rest.server.datastore.converter.ActivityAttributeConverter;
import org.bonitasoft.web.rest.server.datastore.filter.ActivityFilterCreator;
import org.bonitasoft.web.rest.server.datastore.filter.Filters;
import org.bonitasoft.web.rest.server.datastore.utils.SearchOptionsCreator;
import org.bonitasoft.web.rest.server.datastore.utils.Sorts;
import org.bonitasoft.web.rest.server.datastore.utils.VariableMapper;
import org.bonitasoft.web.rest.server.datastore.utils.VariablesMapper;
import org.bonitasoft.web.rest.server.engineclient.ActivityEngineClient;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.EngineClientFactory;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemNotFoundException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;
import org.bonitasoft.web.toolkit.client.data.item.Item;

public class AbstractActivityDatastore<CONSOLE_ITEM extends ActivityItem, ENGINE_ITEM extends ActivityInstance>
extends AbstractFlowNodeDatastore<CONSOLE_ITEM, ENGINE_ITEM>
implements DatastoreHasGet<CONSOLE_ITEM>,
DatastoreHasUpdate<CONSOLE_ITEM> {
    public AbstractActivityDatastore(APISession engineSession) {
        super(engineSession);
    }

    protected static ActivityItem fillConsoleItem(ActivityItem result, ActivityInstance item) {
        FlowNodeDatastore.fillConsoleItem(result, (FlowNodeInstance)item);
        result.setReachStateDate(item.getReachedStateDate());
        result.setLastUpdateDate(item.getLastUpdateDate());
        return result;
    }

    @Override
    public CONSOLE_ITEM get(APIID id) {
        try {
            ActivityInstance activityInstance = this.getProcessAPI().getActivityInstance(id.toLong().longValue());
            return (CONSOLE_ITEM)((ActivityItem)this.convertEngineToConsoleItem(activityInstance));
        }
        catch (ActivityInstanceNotFoundException e) {
            throw new APIItemNotFoundException("activity", id);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected SearchResult<ENGINE_ITEM> runSearch(SearchOptionsBuilder builder, Map<String, String> filters) {
        try {
            SearchResult results = this.getProcessAPI().searchActivities(builder.done());
            return results;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    protected SearchOptionsBuilder makeSearchOptionBuilder(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        return new SearchOptionsCreator(page, resultsByPage, search, new Sorts(orders, new ActivityAttributeConverter()), new Filters(filters, new ActivityFilterCreator())).getBuilder();
    }

    @Override
    public CONSOLE_ITEM update(APIID id, Map<String, String> attributes) {
        String jsonVariables = MapUtil.getValue(attributes, "variables", null);
        if (!StringUtil.isBlank(jsonVariables)) {
            this.updateActivityVariables(id.toLong(), jsonVariables);
        }
        this.update(this.get(id), attributes);
        return null;
    }

    private void updateActivityVariables(long activityId, String jsonValue) {
        ActivityEngineClient activityEngineclient = this.getActivityEngineClient();
        HashMap<String, Serializable> variables = this.buildVariablesMap(activityId, jsonValue, activityEngineclient);
        activityEngineclient.updateVariables(activityId, variables);
    }

    private ActivityEngineClient getActivityEngineClient() {
        return new EngineClientFactory(new EngineAPIAccessor(this.getEngineSession())).createActivityEngineClient();
    }

    private HashMap<String, Serializable> buildVariablesMap(long activityId, String jsonValue, ActivityEngineClient client) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (VariableMapper var : VariablesMapper.fromJson(jsonValue).getVariables()) {
            DataInstance data = client.getDataInstance(var.getName(), activityId);
            map.put(var.getName(), var.getSerializableValue(data.getClassName()));
        }
        return map;
    }

    protected void update(CONSOLE_ITEM item, Map<String, String> attributes) {
        this.updateState(item, MapUtil.getValue(attributes, "state", null), MapUtil.getValue(attributes, "executedBy", null));
    }

    protected void updateState(CONSOLE_ITEM item, String state, String userExecuteById) {
        block7: {
            try {
                if (state == null) {
                    return;
                }
                if ("skipped".equals(state) && item instanceof FlowNodeItem) {
                    this.getProcessAPI().setActivityStateByName(((Item)item).getId().toLong().longValue(), "skipped");
                    break block7;
                }
                if ("completed".equals(state) && item instanceof ActivityItem) {
                    if (userExecuteById != null) {
                        this.getProcessAPI().executeFlowNode(Long.valueOf(userExecuteById).longValue(), ((Item)item).getId().toLong().longValue());
                    } else {
                        this.getProcessAPI().executeFlowNode(((Item)item).getId().toLong().longValue());
                    }
                    break block7;
                }
                throw new APIException("Can't update " + item.getClass().getName() + " state to \"" + state + "\"");
            }
            catch (BonitaException e) {
                throw new APIException(e);
            }
        }
    }
}

