/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.connector.ConnectorCriterion;
import org.bonitasoft.engine.bpm.connector.ConnectorImplementationDescriptor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.process.ProcessConnectorItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class ProcessConnectorDatastore
extends CommonDatastore<ProcessConnectorItem, ConnectorImplementationDescriptor>
implements DatastoreHasGet<ProcessConnectorItem>,
DatastoreHasSearch<ProcessConnectorItem> {
    public ProcessConnectorDatastore(APISession engineSession) {
        super(engineSession);
    }

    protected ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ProcessConnectorItem get(APIID id) {
        try {
            ProcessConnectorItem connector = this.convertEngineToConsoleItem(this.getProcessAPI().getConnectorImplementation(id.getPartAsLong("process_id").longValue(), id.getPart("definition_id"), id.getPart("definition_version")));
            connector.setProcessId(id.getPartAsLong("process_id"));
            return connector;
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<ProcessConnectorItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        Long processId = MapUtil.getValueAsLong(filters, "process_id");
        List connectors = this.getProcessAPI().getConnectorImplementations(processId.longValue(), SearchOptionsBuilderUtil.computeIndex(page, resultsByPage), resultsByPage, ConnectorCriterion.valueOf((String)orders.toUpperCase().replace(" ", "_")));
        ArrayList<ProcessConnectorItem> results = new ArrayList<ProcessConnectorItem>();
        for (ConnectorImplementationDescriptor connector : connectors) {
            ProcessConnectorItem result = this.convertEngineToConsoleItem(connector);
            result.setProcessId(processId);
            results.add(result);
        }
        long numtotalConnectorImplem = this.getProcessAPI().getNumberOfConnectorImplementations(processId.longValue());
        return new ItemSearchResult<ProcessConnectorItem>(page, resultsByPage, numtotalConnectorImplem, results);
    }

    @Override
    protected ProcessConnectorItem convertEngineToConsoleItem(ConnectorImplementationDescriptor item) {
        ProcessConnectorItem result = new ProcessConnectorItem();
        result.setName(item.getDefinitionId());
        result.setVersion(item.getDefinitionVersion());
        result.setImplementationName(item.getId());
        result.setImplementationVersion(item.getVersion());
        result.setClassname(item.getImplementationClassName());
        return result;
    }
}

