/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.utils.ListUtil;
import org.bonitasoft.engine.api.ProcessAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.connector.ConnectorImplementationDescriptor;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.process.ProcessConnectorDependencyItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;

public class ProcessConnectorDependencyDatastore
extends CommonDatastore<ProcessConnectorDependencyItem, ConnectorImplementationDescriptor>
implements DatastoreHasSearch<ProcessConnectorDependencyItem> {
    public ProcessConnectorDependencyDatastore(APISession engineSession) {
        super(engineSession);
    }

    protected ProcessAPI getProcessAPI() {
        try {
            return TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public ItemSearchResult<ProcessConnectorDependencyItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            Long processId = MapUtil.getValueAsLong(filters, "connector_process_id");
            String connectorName = filters.get("connector_name");
            String connectorVersion = filters.get("connector_version");
            ConnectorImplementationDescriptor connectorImplementation = this.getProcessAPI().getConnectorImplementation(processId.longValue(), connectorName, connectorVersion);
            if (connectorImplementation == null) {
                return new ItemSearchResult<ProcessConnectorDependencyItem>(page, 0, 0L, new ArrayList());
            }
            List jarDependencies = connectorImplementation.getJarDependencies();
            List<String> dependencies = ListUtil.paginate(jarDependencies, page, resultsByPage);
            List<ProcessConnectorDependencyItem> results = this.convertEngineToConsoleItems(processId, connectorName, connectorVersion, dependencies);
            return new ItemSearchResult<ProcessConnectorDependencyItem>(page, results.size(), jarDependencies.size(), results);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    private List<ProcessConnectorDependencyItem> convertEngineToConsoleItems(Long processId, String connectorName, String connectorVersion, List<String> dependencies) {
        ArrayList<ProcessConnectorDependencyItem> results = new ArrayList<ProcessConnectorDependencyItem>();
        for (String filename : dependencies) {
            ProcessConnectorDependencyItem dependencyItem = this.convertEngineToConsoleItem(processId, connectorName, connectorVersion, filename);
            results.add(dependencyItem);
        }
        return results;
    }

    private ProcessConnectorDependencyItem convertEngineToConsoleItem(Long processId, String connectorName, String connectorVersion, String filename) {
        ProcessConnectorDependencyItem dependencyItem = new ProcessConnectorDependencyItem();
        dependencyItem.setProcessId(processId);
        dependencyItem.setConnectorName(connectorName);
        dependencyItem.setConnectorVersion(connectorVersion);
        dependencyItem.setFilename(filename);
        return dependencyItem;
    }

    @Override
    protected ProcessConnectorDependencyItem convertEngineToConsoleItem(ConnectorImplementationDescriptor item) {
        return null;
    }
}

