/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.bpm.process;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.bpm.process.Problem;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.web.rest.model.bpm.process.ProcessResolutionProblemItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;

public class ProcessResolutionProblemDatastore
extends CommonDatastore<ProcessResolutionProblemItem, Problem>
implements DatastoreHasSearch<ProcessResolutionProblemItem> {
    public ProcessResolutionProblemDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    protected ProcessResolutionProblemItem convertEngineToConsoleItem(Problem item) {
        ProcessResolutionProblemItem consoleItem = new ProcessResolutionProblemItem();
        consoleItem.setMessage(item.getDescription());
        consoleItem.setTargetType(item.getResource());
        consoleItem.setRessourceId(item.getResourceId());
        return consoleItem;
    }

    @Override
    public ItemSearchResult<ProcessResolutionProblemItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            List errors = TenantAPIAccessor.getProcessAPI((APISession)this.getEngineSession()).getProcessResolutionProblems(MapUtil.getValueAsLong(filters, "process_id").longValue());
            int startIndex = page * resultsByPage;
            return new ItemSearchResult<ProcessResolutionProblemItem>(page, resultsByPage, errors.size(), this.convertEngineToConsoleItemsList(errors.subList(startIndex, Math.min(startIndex + resultsByPage, errors.size()))));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }
}

