/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.IconDescriptor;
import org.bonitasoft.engine.identity.GroupCreator;
import org.bonitasoft.web.rest.model.identity.GroupItem;
import org.bonitasoft.web.rest.server.engineclient.GroupEngineClient;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;

public class GroupCreatorConverter {
    private final GroupEngineClient groupEngineClient;

    public GroupCreatorConverter(GroupEngineClient groupEngineClient) {
        this.groupEngineClient = groupEngineClient;
    }

    public GroupCreator convert(GroupItem item) {
        if (item == null) {
            return null;
        }
        GroupCreator builder = new GroupCreator(item.getName());
        if (!StringUtil.isBlank(item.getDescription())) {
            builder.setDescription(item.getDescription());
        }
        if (!StringUtil.isBlank(item.getDisplayName())) {
            builder.setDisplayName(item.getDisplayName());
        }
        if (!StringUtil.isBlank(item.getIcon())) {
            IconDescriptor iconDescriptor = new BonitaHomeFolderAccessor().getIconFromFileSystem(item.getIcon());
            builder.setIcon(iconDescriptor.getFilename(), iconDescriptor.getContent());
        }
        if (!StringUtil.isBlank(item.getParentGroupId())) {
            String parentGroupPath = this.groupEngineClient.getPath(item.getParentGroupId());
            builder.setParentPath(parentGroupPath);
        }
        return builder;
    }
}

