/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.console.common.server.utils.BonitaHomeFolderAccessor;
import org.bonitasoft.console.common.server.utils.IconDescriptor;
import org.bonitasoft.engine.api.IdentityAPI;
import org.bonitasoft.engine.api.TenantAPIAccessor;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.ServerAPIException;
import org.bonitasoft.engine.exception.UnknownAPITypeException;
import org.bonitasoft.engine.identity.Role;
import org.bonitasoft.engine.identity.RoleCreator;
import org.bonitasoft.engine.identity.RoleNotFoundException;
import org.bonitasoft.engine.identity.RoleUpdater;
import org.bonitasoft.engine.search.SearchOptionsBuilder;
import org.bonitasoft.engine.search.SearchResult;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.InvalidSessionException;
import org.bonitasoft.web.rest.model.identity.RoleItem;
import org.bonitasoft.web.rest.server.datastore.CommonDatastore;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasAdd;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasDelete;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasGet;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasSearch;
import org.bonitasoft.web.rest.server.framework.api.DatastoreHasUpdate;
import org.bonitasoft.web.rest.server.framework.search.ItemSearchResult;
import org.bonitasoft.web.rest.server.framework.utils.SearchOptionsBuilderUtil;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIForbiddenException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APINotFoundException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;
import org.bonitasoft.web.toolkit.client.common.texttemplate.Arg;
import org.bonitasoft.web.toolkit.client.common.util.MapUtil;
import org.bonitasoft.web.toolkit.client.common.util.StringUtil;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class RoleDatastore
extends CommonDatastore<RoleItem, Role>
implements DatastoreHasGet<RoleItem>,
DatastoreHasSearch<RoleItem>,
DatastoreHasAdd<RoleItem>,
DatastoreHasUpdate<RoleItem>,
DatastoreHasDelete {
    public RoleDatastore(APISession engineSession) {
        super(engineSession);
    }

    @Override
    public void delete(List<APIID> ids) {
        try {
            ArrayList<Long> longIds = new ArrayList<Long>();
            for (APIID id : ids) {
                longIds.add(id.toLong());
            }
            this.getIdentityAPI().deleteRoles(longIds);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public RoleItem update(APIID id, Map<String, String> attributes) {
        try {
            RoleUpdater updater = new RoleUpdater();
            if (attributes.containsKey("name")) {
                updater.setName(attributes.get("name"));
            }
            if (attributes.containsKey("displayName")) {
                updater.setDisplayName(attributes.get("displayName"));
            }
            if (attributes.containsKey("description")) {
                updater.setDescription(attributes.get("description"));
            }
            if (!MapUtil.isBlank(attributes, "icon")) {
                IconDescriptor iconDescriptor = this.getBonitaHomeFolderAccessor().getIconFromFileSystem(attributes.get("icon"));
                updater.setIcon(iconDescriptor.getFilename(), iconDescriptor.getContent());
            }
            return this.convertEngineToConsoleItem(this.getIdentityAPI().updateRole(id.toLong().longValue(), updater));
        }
        catch (RoleNotFoundException e) {
            throw new APINotFoundException(new T_("Unable to find role %roleId%", new Arg("roleId", id)));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public RoleItem add(RoleItem role) {
        try {
            RoleCreator creator = new RoleCreator(role.getName());
            if (!StringUtil.isBlank(role.getDisplayName())) {
                creator.setDisplayName(role.getDisplayName());
            }
            if (!StringUtil.isBlank(role.getDescription())) {
                creator.setDescription(role.getDescription());
            }
            if (!StringUtil.isBlank(role.getIcon())) {
                IconDescriptor iconDescriptor = this.getBonitaHomeFolderAccessor().getIconFromFileSystem(role.getIcon());
                creator.setIcon(iconDescriptor.getFilename(), iconDescriptor.getContent());
            }
            return this.convertEngineToConsoleItem(this.getIdentityAPI().createRole(creator));
        }
        catch (AlreadyExistsException e) {
            throw new APIForbiddenException(new T_("Can't create role. Role '%roleName%' already exists", new Arg("roleName", role.getName())), (Throwable)e);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    BonitaHomeFolderAccessor getBonitaHomeFolderAccessor() {
        return new BonitaHomeFolderAccessor();
    }

    @Override
    public ItemSearchResult<RoleItem> search(int page, int resultsByPage, String search, String orders, Map<String, String> filters) {
        try {
            SearchOptionsBuilder builder = SearchOptionsBuilderUtil.buildSearchOptions(page, resultsByPage, orders, search);
            this.addStringFilterToSearchBuilder(filters, builder, "name", "name");
            this.addStringFilterToSearchBuilder(filters, builder, "displayName", "displayName");
            SearchResult engineSearchResults = this.getIdentityAPI().searchRoles(builder.done());
            ArrayList<RoleItem> consoleSearchResults = new ArrayList<RoleItem>();
            for (Role engineItem : engineSearchResults.getResult()) {
                consoleSearchResults.add(this.convertEngineToConsoleItem(engineItem));
            }
            return new ItemSearchResult<RoleItem>(page, resultsByPage, engineSearchResults.getCount(), consoleSearchResults);
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    @Override
    public RoleItem get(APIID id) {
        try {
            return this.convertEngineToConsoleItem(this.getIdentityAPI().getRole(id.toLong().longValue()));
        }
        catch (RoleNotFoundException e) {
            throw new APINotFoundException(new T_("Unable to find role %roleId%", new Arg("roleId", id)));
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    public Long getNumberOfUsers(APIID roleId) {
        try {
            return this.getIdentityAPI().getNumberOfUsersInRole(roleId.toLong().longValue());
        }
        catch (BonitaException e) {
            throw new APIException(e);
        }
    }

    IdentityAPI getIdentityAPI() throws InvalidSessionException, BonitaHomeNotSetException, ServerAPIException, UnknownAPITypeException {
        return TenantAPIAccessor.getIdentityAPI((APISession)this.getEngineSession());
    }

    @Override
    protected RoleItem convertEngineToConsoleItem(Role item) {
        RoleItem roleItem = new RoleItem();
        roleItem.setId(item.getId());
        roleItem.setName(item.getName());
        roleItem.setDisplayName(item.getDisplayName());
        roleItem.setDescription(item.getDescription());
        roleItem.setIcon((String)(item.getIconId() == null ? "" : "../API/avatars/" + item.getIconId()));
        roleItem.setCreatedByUserId(item.getCreatedBy());
        roleItem.setCreationDate(item.getCreationDate());
        roleItem.setLastUpdateDate(item.getLastUpdate());
        return roleItem;
    }
}

