/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.organization;

import org.bonitasoft.engine.identity.User;
import org.bonitasoft.web.rest.model.identity.UserItem;
import org.bonitasoft.web.rest.server.datastore.converter.ItemConverter;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class UserItemConverter
extends ItemConverter<UserItem, User> {
    @Override
    public UserItem convert(User user) {
        if (user == null) {
            return null;
        }
        UserItem result = new UserItem();
        result.setId(APIID.makeAPIID(user.getId()));
        result.setFirstName(user.getFirstName());
        result.setLastName(user.getLastName());
        result.setPassword(null);
        result.setUserName(user.getUserName());
        result.setManagerId(user.getManagerUserId());
        result.setEnabled(user.isEnabled());
        if (user.getIconId() != null) {
            result.setIcon("../API/avatars/" + user.getIconId());
        } else {
            result.setIcon("icons/default/icon_user.png");
        }
        result.setCreationDate(user.getCreationDate());
        result.setCreatedByUserId(user.getCreatedBy());
        result.setLastUpdateDate(user.getLastUpdate());
        result.setLastConnectionDate(user.getLastConnection());
        result.setTitle(user.getTitle());
        result.setJobTitle(user.getJobTitle());
        return result;
    }
}

