/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.datastore.page;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.bonitasoft.web.rest.server.datastore.page.InvalidPageZipContentException;

public class CustomPageContentValidator {
    private static final String INDEX_GROOVY = "Index.groovy";
    private static final String INDEX_HTML = "index.html";
    private static final String PAGE_PROPERTIES = "page.properties";
    private static final String THEME_CSS = "theme.css";

    public void validate(File pageFolder) throws InvalidPageZipContentException {
        File[] rootFiles = pageFolder.listFiles();
        if (rootFiles == null) {
            throw new InvalidPageZipContentException("Content not found.");
        }
        Properties pageProperties = Stream.of(rootFiles).filter(file -> file.getName().matches(PAGE_PROPERTIES)).findFirst().map(this::loadProperties).orElseThrow(() -> new InvalidPageZipContentException(String.format("%s descriptor is missing.", PAGE_PROPERTIES)));
        String contentType = pageProperties.getProperty("contentType");
        Optional<File> resouresFolder = Stream.of(rootFiles).filter(file -> file.getName().matches("resources")).findFirst();
        if (Objects.equals(contentType, "theme")) {
            if (!resouresFolder.filter(resources -> new File((File)resources, THEME_CSS).exists()).isPresent()) {
                throw new InvalidPageZipContentException(String.format("%s is missing.", THEME_CSS));
            }
        } else if (!Objects.equals(contentType, "apiExtension") && Stream.of(rootFiles).noneMatch(file -> file.getName().matches(INDEX_HTML) || file.getName().matches(INDEX_GROOVY)) && !resouresFolder.filter(resources -> new File((File)resources, INDEX_HTML).exists() || new File((File)resources, INDEX_GROOVY).exists()).isPresent()) {
            throw new InvalidPageZipContentException(String.format("%s or %s is missing.", INDEX_HTML, INDEX_GROOVY));
        }
    }

    private Properties loadProperties(File pagePropertyFile) {
        Properties pageProperties = new Properties();
        try (FileInputStream is = new FileInputStream(pagePropertyFile);){
            pageProperties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load page.properties file.", e);
        }
        return pageProperties;
    }
}

