/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import org.bonitasoft.web.rest.server.engineclient.ActivityEngineClient;
import org.bonitasoft.web.rest.server.engineclient.CaseEngineClient;
import org.bonitasoft.web.rest.server.engineclient.EngineAPIAccessor;
import org.bonitasoft.web.rest.server.engineclient.GroupEngineClient;
import org.bonitasoft.web.rest.server.engineclient.HumanTaskEngineClient;
import org.bonitasoft.web.rest.server.engineclient.ProcessEngineClient;
import org.bonitasoft.web.rest.server.engineclient.ProfileEngineClient;
import org.bonitasoft.web.rest.server.engineclient.ProfileMemberEngineClient;
import org.bonitasoft.web.rest.server.engineclient.TenantManagementEngineClient;
import org.bonitasoft.web.rest.server.engineclient.UserEngineClient;

public class EngineClientFactory {
    private final EngineAPIAccessor apiAccessor;

    public EngineClientFactory(EngineAPIAccessor apiAccessor) {
        this.apiAccessor = apiAccessor;
    }

    public ProfileEngineClient createProfileEngineClient() {
        return new ProfileEngineClient(this.apiAccessor.getProfileAPI());
    }

    public ProfileMemberEngineClient createProfileMemberEngineClient() {
        return new ProfileMemberEngineClient(this.apiAccessor.getProfileAPI());
    }

    public ProcessEngineClient createProcessEngineClient() {
        return new ProcessEngineClient(this.apiAccessor.getProcessAPI());
    }

    public CaseEngineClient createCaseEngineClient() {
        return new CaseEngineClient(this.apiAccessor.getProcessAPI());
    }

    public HumanTaskEngineClient createHumanTaskEngineClient() {
        return new HumanTaskEngineClient(this.apiAccessor.getProcessAPI());
    }

    public ActivityEngineClient createActivityEngineClient() {
        return new ActivityEngineClient(this.apiAccessor.getProcessAPI());
    }

    public UserEngineClient createUserEngineClient() {
        return new UserEngineClient(this.apiAccessor.getIdentityAPI());
    }

    public GroupEngineClient createGroupEngineClient() {
        return new GroupEngineClient(this.apiAccessor.getGroupAPI());
    }

    public TenantManagementEngineClient createTenantManagementEngineClient() {
        return new TenantManagementEngineClient(this.apiAccessor.getTenantAdministrationAPI());
    }
}

