/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.engineclient;

import org.bonitasoft.engine.api.TenantAdministrationAPI;
import org.bonitasoft.engine.exception.UpdateException;
import org.bonitasoft.web.toolkit.client.common.exception.api.APIException;
import org.bonitasoft.web.toolkit.client.common.i18n.T_;

public class TenantManagementEngineClient {
    private final TenantAdministrationAPI tenantAdministrationAPI;

    public TenantManagementEngineClient(TenantAdministrationAPI tenantManagementAPI) {
        this.tenantAdministrationAPI = tenantManagementAPI;
    }

    public boolean isTenantPaused() {
        return this.tenantAdministrationAPI.isPaused();
    }

    public void pauseTenant() {
        if (!this.isTenantPaused()) {
            this.pause();
        }
    }

    private void pause() {
        try {
            this.tenantAdministrationAPI.pause();
        }
        catch (UpdateException e) {
            throw new APIException(new T_("Error when pausing BPM services"), (Throwable)e);
        }
    }

    public void resumeTenant() {
        if (this.isTenantPaused()) {
            this.resume();
        }
    }

    private void resume() {
        try {
            this.tenantAdministrationAPI.resume();
        }
        catch (UpdateException e) {
            throw new APIException(new T_("Error when resuming BPM services"), (Throwable)e);
        }
    }
}

