/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.rest.server.framework.utils.converter;

import java.util.Date;
import org.bonitasoft.web.rest.server.framework.utils.converter.Converter;
import org.bonitasoft.web.rest.server.framework.utils.converter.typed.BooleanConverter;
import org.bonitasoft.web.rest.server.framework.utils.converter.typed.DateConverter;
import org.bonitasoft.web.rest.server.framework.utils.converter.typed.DoubleConverter;
import org.bonitasoft.web.rest.server.framework.utils.converter.typed.IntegerConverter;
import org.bonitasoft.web.rest.server.framework.utils.converter.typed.LongConverter;
import org.bonitasoft.web.rest.server.framework.utils.converter.typed.StringConverter;

public class ConverterFactory {
    public Converter<?> createConverter(String className) {
        if (this.isClass(String.class, className)) {
            return new StringConverter();
        }
        if (this.isClass(Date.class, className)) {
            return new DateConverter();
        }
        if (this.isClass(Double.class, className)) {
            return new DoubleConverter();
        }
        if (this.isClass(Long.class, className)) {
            return new LongConverter();
        }
        if (this.isClass(Boolean.class, className)) {
            return new BooleanConverter();
        }
        if (this.isClass(Integer.class, className)) {
            return new IntegerConverter();
        }
        throw new UnsupportedOperationException("Canno't create converter for class name : " + className);
    }

    private boolean isClass(Class<?> classe, String className) {
        return classe.getName().equals(className);
    }
}

