/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.exception.api;

import org.bonitasoft.web.toolkit.client.common.exception.api.APIItemException;
import org.bonitasoft.web.toolkit.client.common.exception.http.JsonExceptionSerializer;
import org.bonitasoft.web.toolkit.client.data.APIID;

public class APIItemNotFoundException
extends APIItemException {
    private static final long serialVersionUID = -1325943431826471828L;
    private final APIID id;

    public APIItemNotFoundException(String itemType) {
        this(itemType, (APIID)null);
    }

    public APIItemNotFoundException(String itemType, APIID id) {
        super(itemType);
        this.id = id;
    }

    public APIID getId() {
        return this.id;
    }

    @Override
    protected JsonExceptionSerializer buildJson() {
        JsonExceptionSerializer json = super.buildJson();
        if (this.id != null) {
            json.appendAttribute("id", this.getId());
        }
        return json;
    }

    @Override
    protected String defaultMessage() {
        StringBuilder message = new StringBuilder();
        message.append(this.itemType.substring(0, 1).toUpperCase());
        message.append(this.itemType.substring(1));
        if (this.id != null) {
            message.append(" with id (");
            message.append(this.getId().toString());
            message.append(")");
        }
        message.append(" not found for API ");
        message.append(this.getApi());
        message.append("#");
        message.append(this.getResource());
        return message.toString();
    }
}

