/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.json;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.bonitasoft.web.toolkit.client.common.exception.http.JsonExceptionSerializer;
import org.bonitasoft.web.toolkit.client.common.json.JSonUtil;
import org.bonitasoft.web.toolkit.client.common.json.JsonSerializable;

public class JSonSerializer
extends JSonUtil {
    private static final ThreadLocal<SimpleDateFormat> dateTimeFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));

    public static String serialize(JsonSerializable object) {
        return JSonSerializer.serializeInternal(object).toString();
    }

    private static StringBuilder serializeInternal(JsonSerializable object) {
        if (object == null) {
            return new StringBuilder("null");
        }
        return new StringBuilder(object.toJson());
    }

    public static String serialize(Object object) {
        return JSonSerializer.serializeInternal(object).toString();
    }

    private static StringBuilder serializeInternal(Object object) {
        if (object == null) {
            return new StringBuilder("null");
        }
        if (object instanceof JsonSerializable) {
            return JSonSerializer.serializeInternal((JsonSerializable)object);
        }
        if (object instanceof Collection) {
            return JSonSerializer.serializeCollectionInternal((Collection)object);
        }
        if (object instanceof Map) {
            return JSonSerializer.serializeMapInternal((Map)object);
        }
        if (object instanceof Number) {
            return new StringBuilder(object.toString());
        }
        if (object instanceof Boolean) {
            return new StringBuilder((Boolean)object != false ? "true" : "false");
        }
        if (object instanceof Date) {
            return JSonSerializer.quoteInternal(dateTimeFormat.get().format((Date)object));
        }
        if (object instanceof Throwable) {
            return new StringBuilder(JSonSerializer.serializeException((Throwable)object));
        }
        return JSonSerializer.quoteInternal(object.toString());
    }

    public static String serializeCollection(Collection<?> list) {
        return JSonSerializer.serializeCollectionInternal(list).toString();
    }

    private static StringBuilder serializeCollectionInternal(Collection<?> list) {
        StringBuilder json = new StringBuilder("[");
        boolean first = true;
        for (Object item : list) {
            json.append(!first ? "," : "").append((CharSequence)JSonSerializer.serializeInternal(item));
            first = false;
        }
        json.append("]");
        return json;
    }

    public static String serializeMap(Map<?, ?> map) {
        return JSonSerializer.serializeMapInternal(map).toString();
    }

    private static StringBuilder serializeMapInternal(Map<?, ?> map) {
        StringBuilder json = new StringBuilder().append("{");
        boolean first = true;
        for (Object key : map.keySet()) {
            json.append(!first ? "," : "").append((CharSequence)JSonSerializer.quoteInternal(key.toString())).append(":").append((CharSequence)JSonSerializer.serializeInternal(map.get(key)));
            first = false;
        }
        json.append("}");
        return json;
    }

    public static String serializeException(Throwable e) {
        return new JsonExceptionSerializer(e).end();
    }

    public static String serializeStringMap(Map<?, String> map) {
        return JSonSerializer.serializeStringMapInternal(map).toString();
    }

    private static StringBuilder serializeStringMapInternal(Map<?, String> map) {
        StringBuilder json = new StringBuilder("{");
        boolean first = true;
        for (Object key : map.keySet()) {
            json.append(!first ? "," : "").append((CharSequence)JSonSerializer.quoteInternal(key.toString())).append(":").append((CharSequence)JSonSerializer.quoteInternal(map.get(key)));
            first = false;
        }
        json.append("}");
        return json;
    }
}

