/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.common.util;

public abstract class StringUtil {
    public static Boolean toBoolean(String value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        if ("true".equals(value) || "yes".equals(value) || "ok".equals(value)) {
            return true;
        }
        if ("false".equals(value) || "no".equals(value) || "ko".equals(value)) {
            return false;
        }
        try {
            return Integer.parseInt(value) > 0;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(value + " is not a valid boolean value");
        }
    }

    public static Integer toInteger(String value) throws NumberFormatException {
        if (value == null) {
            return null;
        }
        return Integer.valueOf(value);
    }

    public static boolean isBlank(String value) {
        return value == null || value.isEmpty() || value.trim().isEmpty();
    }
}

