/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.toolkit.client.data.item.attribute.validator;

import org.bonitasoft.web.toolkit.client.common.i18n.AbstractI18n;
import org.bonitasoft.web.toolkit.client.data.item.attribute.validator.AbstractStringFormatValidator;

public class FileIsImageOrServletPathValidator
extends AbstractStringFormatValidator {
    private static final String[] IMAGE_EXTENSIONS = new String[]{"png", "jpg", "jpeg", "bmp", "wbmp", "tga", "gif", "PNG", "JPG", "JPEG", "BMP", "WBMP", "TGA", "GIF"};

    public FileIsImageOrServletPathValidator(String servletPath) {
        super(FileIsImageOrServletPathValidator.makeRegexp(IMAGE_EXTENSIONS, servletPath));
    }

    private static String makeRegexp(String[] extensions, String servletPath) {
        StringBuilder sb = new StringBuilder();
        for (String extension : extensions) {
            sb.append(extension).append("|");
        }
        String preparedServletPath = servletPath.replace(".", "\\.").replace("/", "\\/");
        return "^" + preparedServletPath + "|\\.(" + sb.substring(0, sb.length() - 1) + ")$";
    }

    @Override
    protected String defineErrorMessage() {
        return AbstractI18n.t_("%attribute% file format not allowed or not starting with correct servlet path");
    }
}

