/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fedorahosted.tennera.jgettext.catalog.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message {
    private String domain;
    private String msgctxt;
    private String msgid;
    private String msgidPlural;
    private String msgstr;
    private List<String> msgstrPlural = new ArrayList<String>();
    private String prevMsgctx;
    private String prevMsgid;
    private String prevMsgidPlural;
    private Collection<String> comments = new ArrayList<String>();
    private Collection<String> extractedComments = new ArrayList<String>();
    private List<String> sourceRefs = new ArrayList<String>();
    private Collection<String> formats = new ArrayList<String>();
    private boolean obsolete;
    private Boolean allowWrap;

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getMsgctxt() {
        return this.msgctxt;
    }

    public void setMsgctxt(String msgctxt) {
        this.msgctxt = msgctxt;
    }

    public String getPrevMsgctx() {
        return this.prevMsgctx;
    }

    public void setPrevMsgctx(String prevMsgctx) {
        this.prevMsgctx = prevMsgctx;
    }

    public String getMsgid() {
        return this.msgid;
    }

    public void setMsgid(String msgid) {
        this.msgid = msgid;
    }

    public String getPrevMsgid() {
        return this.prevMsgid;
    }

    public void setPrevMsgid(String prevMsgid) {
        this.prevMsgid = prevMsgid;
    }

    public String getMsgidPlural() {
        return this.msgidPlural;
    }

    public void setMsgidPlural(String msgidPlural) {
        this.msgidPlural = msgidPlural;
    }

    public String getPrevMsgidPlural() {
        return this.prevMsgidPlural;
    }

    public void setPrevMsgidPlural(String prevMsgidPlural) {
        this.prevMsgidPlural = prevMsgidPlural;
    }

    public String getMsgstr() {
        return this.msgstr;
    }

    public void setMsgstr(String msgstr) {
        if (msgstr == null) {
            throw new NullPointerException("msgstr cannot be null");
        }
        this.msgstr = msgstr;
        this.clearPlurals();
    }

    private void clearPlurals() {
        if (this.msgstrPlural == null) {
            return;
        }
        this.msgstrPlural.clear();
    }

    public void addMsgstrPlural(String msgstr, int position) {
        if (msgstr == null) {
            throw new NullPointerException("msgstr cannot be null");
        }
        if (this.msgstrPlural == null) {
            this.msgstrPlural = new ArrayList<String>();
        }
        this.msgstrPlural.add(position, msgstr);
    }

    public void markFuzzy() {
        if (!this.formats.contains("fuzzy")) {
            this.formats.add("fuzzy");
        }
    }

    public boolean isFuzzy() {
        if (this.getMsgstr() != null && this.getMsgstr().isEmpty()) {
            return false;
        }
        return this.formats.contains("fuzzy");
    }

    public void setFuzzy(boolean fuzzy) {
        boolean containsFuzzy = this.formats.contains("fuzzy");
        if (fuzzy) {
            if (!containsFuzzy) {
                this.formats.add("fuzzy");
            }
        } else if (containsFuzzy) {
            this.formats.remove("fuzzy");
        }
    }

    public void markObsolete() {
        this.obsolete = true;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }

    public Boolean getAllowWrap() {
        return this.allowWrap;
    }

    public void setAllowWrap(Boolean allowWrap) {
        this.allowWrap = allowWrap;
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public void addExtractedComment(String comment) {
        this.extractedComments.add(comment);
    }

    public void addSourceReference(String ref) {
        this.sourceRefs.add(ref);
    }

    public void addSourceReference(String file, int line) {
        this.addSourceReference(file + ':' + line);
    }

    public void addFormat(String format) {
        this.formats.add(format);
    }

    public boolean isHeader() {
        return this.msgctxt == null && "".equals(this.msgid);
    }

    public List<String> getMsgstrPlural() {
        if (this.msgstrPlural == null) {
            this.msgstrPlural = new ArrayList<String>();
        }
        return this.msgstrPlural;
    }

    public boolean isPlural() {
        return this.msgidPlural != null;
    }

    public List<String> getSourceReferences() {
        return this.sourceRefs;
    }

    public Collection<String> getComments() {
        return this.comments;
    }

    public Collection<String> getExtractedComments() {
        return this.extractedComments;
    }

    public Collection<String> getFormats() {
        return this.formats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message(msgctxt ").append(StringUtil.quote(this.msgctxt)).append(", msgid ").append(StringUtil.quote(this.getMsgid())).append(", msgstr \"").append(this.getMsgstr());
        if (!this.getComments().isEmpty()) {
            sb.append("\", transComments \"").append(this.getComments());
        }
        if (!this.getExtractedComments().isEmpty()) {
            sb.append("\", extComments \"").append(this.getExtractedComments());
        }
        if (!this.getFormats().isEmpty()) {
            sb.append("\", flags \"").append(this.getFormats());
        }
        if (!this.getSourceReferences().isEmpty()) {
            sb.append("\", references \"").append(this.getSourceReferences());
        }
        sb.append("\")");
        return sb.toString();
    }
}

