/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup.jndi;

import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jndi.JndiTemplate;
import org.springframework.stereotype.Component;

@Component
public class MemoryJNDISetup
implements DisposableBean,
InitializingBean {
    public static final String BONITA_NON_MANAGED_DS_JNDI_NAME = "java:comp/env/bonitaSequenceManagerDS";
    private final Logger logger = LoggerFactory.getLogger((String)MemoryJNDISetup.class.getSimpleName());
    private final JndiTemplate jndiTemplate;
    private final DataSource datasource;

    @Autowired
    public MemoryJNDISetup(DataSource datasource) throws NamingException {
        this.datasource = datasource;
        System.setProperty("java.naming.factory.initial", "org.bonitasoft.platform.setup.jndi.SimpleMemoryContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "org.bonitasoft.platform.setup.jndi");
        this.jndiTemplate = new JndiTemplate();
    }

    public void afterPropertiesSet() throws NamingException {
        this.logger.info("Binding java:comp/env/bonitaSequenceManagerDS @ " + this.datasource.toString());
        this.jndiTemplate.bind(BONITA_NON_MANAGED_DS_JNDI_NAME, (Object)this.datasource);
    }

    public void destroy() throws NamingException {
        this.logger.info("Unbinding java:comp/env/bonitaSequenceManagerDS");
        this.jndiTemplate.unbind(BONITA_NON_MANAGED_DS_JNDI_NAME);
    }
}

