/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.bonitasoft.platform.configuration.impl.ConfigurationColumns;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.bonitasoft.platform.database.DatabaseVendor;
import org.bonitasoft.platform.setup.PlatformSetup;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.support.lob.TemporaryLobCreator;

public class BonitaAllConfigurationPreparedStatementSetter
implements BatchPreparedStatementSetter,
ConfigurationColumns {
    public static final String INSERT_CONFIGURATION = "INSERT into configuration(content_type, resource_name, resource_content) values (?,?,?)";
    private final List<FullBonitaConfiguration> bonitaConfigurations;
    private final String dbVendor;

    public BonitaAllConfigurationPreparedStatementSetter(List<FullBonitaConfiguration> bonitaConfigurations, String dbVendor) {
        this.bonitaConfigurations = bonitaConfigurations;
        this.dbVendor = dbVendor == null ? PlatformSetup.getPropertyBonitaDbVendor() : dbVendor;
    }

    public void setValues(PreparedStatement ps, int i) throws SQLException {
        FullBonitaConfiguration bonitaConfiguration = this.bonitaConfigurations.get(i);
        ps.setString(1, bonitaConfiguration.getConfigurationType());
        ps.setString(2, bonitaConfiguration.getResourceName());
        switch (DatabaseVendor.parseValue(this.dbVendor)) {
            case H2: 
            case POSTGRES: {
                ps.setBytes(3, bonitaConfiguration.getResourceContent());
                break;
            }
            case ORACLE: 
            case MYSQL: 
            case SQLSERVER: {
                TemporaryLobCreator temporaryLobCreator = new TemporaryLobCreator();
                temporaryLobCreator.setBlobAsBytes(ps, 3, bonitaConfiguration.getResourceContent());
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported db vendor:" + this.dbVendor);
            }
        }
    }

    public int getBatchSize() {
        return this.bonitaConfigurations.size();
    }
}

