/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.bonitasoft.platform.configuration.impl.ConfigurationColumns;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.bonitasoft.platform.database.DatabaseVendor;
import org.bonitasoft.platform.setup.PlatformSetup;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.support.lob.TemporaryLobCreator;

public class BonitaConfigurationPreparedStatementSetter
implements BatchPreparedStatementSetter,
ConfigurationColumns {
    public static final String INSERT_CONFIGURATION = "INSERT into configuration(content_type, resource_name, resource_content) values (?,?,?)";
    private final List<BonitaConfiguration> bonitaConfigurations;
    private final String dbVendor;
    private final ConfigurationType type;

    public BonitaConfigurationPreparedStatementSetter(List<BonitaConfiguration> bonitaConfigurations, String dbVendor, ConfigurationType type) {
        this.bonitaConfigurations = bonitaConfigurations;
        this.dbVendor = dbVendor == null ? PlatformSetup.getPropertyBonitaDbVendor() : dbVendor;
        this.type = type;
    }

    public void setValues(PreparedStatement ps, int i) throws SQLException {
        BonitaConfiguration bonitaConfiguration = this.bonitaConfigurations.get(i);
        ps.setString(1, this.type.toString());
        ps.setString(2, bonitaConfiguration.getResourceName());
        switch (DatabaseVendor.parseValue(this.dbVendor)) {
            case H2: 
            case POSTGRES: {
                ps.setBytes(3, bonitaConfiguration.getResourceContent());
                break;
            }
            case ORACLE: 
            case MYSQL: 
            case SQLSERVER: {
                new TemporaryLobCreator().setBlobAsBytes(ps, 3, bonitaConfiguration.getResourceContent());
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported db vendor:" + this.dbVendor);
            }
        }
    }

    public int getBatchSize() {
        return this.bonitaConfigurations.size();
    }
}

