/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.platform.configuration.ConfigurationService;
import org.bonitasoft.platform.configuration.impl.FolderResolver;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.bonitasoft.platform.configuration.model.LightBonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.bonitasoft.platform.configuration.util.AllConfigurationResourceVisitor;
import org.bonitasoft.platform.configuration.util.AutoUpdateConfigurationVisitor;
import org.bonitasoft.platform.configuration.util.CleanAndStoreAllConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.CleanAndStoreConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.ConfigurationResourceVisitor;
import org.bonitasoft.platform.configuration.util.DeleteAllConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.GetAllConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.GetConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.GetConfigurationsInTransaction;
import org.bonitasoft.platform.configuration.util.GetMandatoryStructureConfiguration;
import org.bonitasoft.platform.configuration.util.LicensesResourceVisitor;
import org.bonitasoft.platform.configuration.util.StoreConfigurationInTransaction;
import org.bonitasoft.platform.configuration.util.StoreConfigurationsIfNotExist;
import org.bonitasoft.platform.configuration.util.UpdateConfigurationInTransaction;
import org.bonitasoft.platform.exception.PlatformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class ConfigurationServiceImpl
implements ConfigurationService {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;
    private final String dbVendor;

    public ConfigurationServiceImpl(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate, @Value(value="${db.vendor}") String dbVendor) {
        this.jdbcTemplate = jdbcTemplate;
        this.transactionTemplate = transactionTemplate;
        this.dbVendor = dbVendor;
    }

    @Override
    public List<BonitaConfiguration> getPlatformPortalConf() {
        return this.getBonitaConfigurations(ConfigurationType.PLATFORM_PORTAL);
    }

    @Override
    public List<BonitaConfiguration> getPlatformEngineConf() {
        return this.getBonitaConfigurations(ConfigurationType.PLATFORM_ENGINE);
    }

    @Override
    public void storeTenantSecurityScripts(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.TENANT_SECURITY_SCRIPTS);
    }

    @Override
    public void storePlatformConfiguration(File configurationRootFolder) throws PlatformException {
        this.storeConfiguration(configurationRootFolder, ConfigurationType.PLATFORM_ENGINE);
    }

    @Override
    public void storeAllConfiguration(Path configurationRootFolder) throws PlatformException {
        ArrayList<FullBonitaConfiguration> fullBonitaConfigurations = new ArrayList<FullBonitaConfiguration>();
        AllConfigurationResourceVisitor allConfigurationResourceVisitor = new AllConfigurationResourceVisitor(fullBonitaConfigurations);
        try {
            Files.walkFileTree(configurationRootFolder, allConfigurationResourceVisitor);
            this.transactionTemplate.execute((TransactionCallback)new CleanAndStoreAllConfigurationInTransaction(this.jdbcTemplate, this.dbVendor, fullBonitaConfigurations));
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    @Override
    public void updateDefaultConfiguration(Path configurationRootFolder) throws PlatformException {
        ArrayList<BonitaConfiguration> bonitaConfigurations = new ArrayList<BonitaConfiguration>();
        try {
            Files.walkFileTree(configurationRootFolder, new AutoUpdateConfigurationVisitor(bonitaConfigurations));
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
        this.updateTenantPortalConf(bonitaConfigurations);
    }

    @Override
    public void storeTenantPortalConf(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.TENANT_PORTAL);
    }

    @Override
    public void updateTenantPortalConf(List<BonitaConfiguration> bonitaConfigurations) {
        this.transactionTemplate.execute((TransactionCallback)new UpdateConfigurationInTransaction(this.jdbcTemplate, this.dbVendor, bonitaConfigurations, ConfigurationType.TENANT_PORTAL));
    }

    @Override
    public List<BonitaConfiguration> getTenantPortalConf() {
        return this.getBonitaConfigurations(ConfigurationType.TENANT_PORTAL);
    }

    @Override
    public BonitaConfiguration getTenantPortalConfiguration(String file) {
        return this.getBonitaConfiguration(ConfigurationType.TENANT_PORTAL, file);
    }

    @Override
    public List<File> writeAllConfigurationToFolder(File configurationFolder, File licenseFolder) throws PlatformException {
        FolderResolver folderResolver = new FolderResolver(configurationFolder.toPath(), licenseFolder.toPath());
        ArrayList<File> writtenFiles = new ArrayList<File>();
        for (FullBonitaConfiguration fullBonitaConfiguration : this.getAllConfiguration()) {
            File confFile = new File(folderResolver.getFolder(fullBonitaConfiguration), fullBonitaConfiguration.getResourceName());
            writtenFiles.add(confFile);
            LOGGER.debug(String.format("writing file %s to folder %s", confFile.getName(), confFile.getParentFile().getAbsolutePath()));
            try (FileOutputStream output = new FileOutputStream(confFile);){
                IOUtils.write((byte[])fullBonitaConfiguration.getResourceContent(), (OutputStream)output);
            }
            catch (IOException e) {
                throw new PlatformException(e);
            }
        }
        return writtenFiles;
    }

    protected List<FullBonitaConfiguration> getAllConfiguration() {
        return (List)this.transactionTemplate.execute((TransactionCallback)new GetAllConfigurationInTransaction(this.jdbcTemplate));
    }

    private void storeConfiguration(File configurationRootFolder, ConfigurationType type) throws PlatformException {
        Path path = configurationRootFolder.toPath();
        ArrayList<BonitaConfiguration> bonitaConfigurations = new ArrayList<BonitaConfiguration>();
        ConfigurationResourceVisitor configurationResourceVisitor = new ConfigurationResourceVisitor(bonitaConfigurations);
        try {
            Files.walkFileTree(path, configurationResourceVisitor);
            this.storeConfiguration(bonitaConfigurations, type);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    @Override
    public void storePlatformEngineConf(List<BonitaConfiguration> bonitaConfigurations) {
        this.storeConfiguration(bonitaConfigurations, ConfigurationType.PLATFORM_ENGINE);
    }

    private void storeConfiguration(List<BonitaConfiguration> bonitaConfigurations, ConfigurationType type) {
        this.transactionTemplate.execute((TransactionCallback)new StoreConfigurationInTransaction(this.jdbcTemplate, this.dbVendor, bonitaConfigurations, type));
    }

    private void cleanAndStoreLicenseConfiguration(List<BonitaConfiguration> bonitaConfigurations) {
        this.transactionTemplate.execute((TransactionCallback)new CleanAndStoreConfigurationInTransaction(this.jdbcTemplate, this.dbVendor, bonitaConfigurations, ConfigurationType.LICENSES));
    }

    @Override
    public List<BonitaConfiguration> getTenantEngineConf() {
        return this.getBonitaConfigurations(ConfigurationType.TENANT_ENGINE);
    }

    List<BonitaConfiguration> getBonitaConfigurations(ConfigurationType type) {
        return (List)this.transactionTemplate.execute((TransactionCallback)new GetConfigurationsInTransaction(this.jdbcTemplate, type));
    }

    @Override
    public List<BonitaConfiguration> getTenantSecurityScripts() {
        return this.getBonitaConfigurations(ConfigurationType.TENANT_SECURITY_SCRIPTS);
    }

    private BonitaConfiguration getBonitaConfiguration(ConfigurationType type, String resourceName) {
        return (BonitaConfiguration)this.transactionTemplate.execute((TransactionCallback)new GetConfigurationInTransaction(this.jdbcTemplate, type, resourceName));
    }

    @Override
    public void storeLicenses(File licensesFolder) throws PlatformException {
        Path path = licensesFolder.toPath();
        ArrayList<BonitaConfiguration> bonitaConfigurations = new ArrayList<BonitaConfiguration>();
        LicensesResourceVisitor licensesResourceVisitor = new LicensesResourceVisitor(bonitaConfigurations);
        try {
            Files.walkFileTree(path, licensesResourceVisitor);
            this.cleanAndStoreLicenseConfiguration(bonitaConfigurations);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    @Override
    public List<BonitaConfiguration> getLicenses() {
        return this.getBonitaConfigurations(ConfigurationType.LICENSES);
    }

    @Override
    public void deleteAllConfiguration() {
        this.transactionTemplate.execute((TransactionCallback)new DeleteAllConfigurationInTransaction(this.jdbcTemplate));
    }

    @Override
    public List<LightBonitaConfiguration> getMandatoryStructureConfiguration() {
        return (List)this.transactionTemplate.execute((TransactionCallback)new GetMandatoryStructureConfiguration(this.jdbcTemplate));
    }

    @Override
    public void storeConfigurationsIfNotExist(List<FullBonitaConfiguration> configurations) {
        this.transactionTemplate.execute((TransactionCallback)new StoreConfigurationsIfNotExist(this.jdbcTemplate, this.dbVendor, configurations));
    }
}

