/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.util.List;
import org.bonitasoft.platform.configuration.impl.BonitaConfigurationRowMapper;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class GetConfigurationInTransaction
implements TransactionCallback<BonitaConfiguration> {
    private final JdbcTemplate jdbcTemplate;
    private final ConfigurationType type;
    private final String resourceName;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);

    public GetConfigurationInTransaction(JdbcTemplate jdbcTemplate, ConfigurationType type, String resourceName) {
        this.jdbcTemplate = jdbcTemplate;
        this.type = type;
        this.resourceName = resourceName;
    }

    public BonitaConfiguration doInTransaction(TransactionStatus status) {
        LOGGER.debug("get configurations for type:{} resource:{}", (Object)this.type.name(), (Object)this.resourceName);
        List bonitaConfigurations = this.jdbcTemplate.query("SELECT content_type, resource_name, resource_content FROM configuration WHERE content_type = ? AND resource_name = ?", new Object[]{this.type.name(), this.resourceName}, (RowMapper)new BonitaConfigurationRowMapper());
        LOGGER.debug("configurations found:{}", (Object)bonitaConfigurations);
        if (bonitaConfigurations.size() == 1) {
            return (BonitaConfiguration)bonitaConfigurations.get(0);
        }
        return null;
    }
}

