/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.configuration.util;

import java.util.List;
import lombok.Generated;
import org.bonitasoft.platform.configuration.impl.BonitaConfigurationRowMapper;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class GetConfigurationsInTransaction
implements TransactionCallback<List<BonitaConfiguration>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetConfigurationsInTransaction.class);
    private final JdbcTemplate jdbcTemplate;
    private final ConfigurationType type;

    public GetConfigurationsInTransaction(JdbcTemplate jdbcTemplate, ConfigurationType type) {
        this.jdbcTemplate = jdbcTemplate;
        this.type = type;
    }

    public List<BonitaConfiguration> doInTransaction(TransactionStatus status) {
        log.debug("get configurations for type:{}", (Object)this.type.name());
        List bonitaConfigurations = this.jdbcTemplate.query("SELECT content_type, resource_name, resource_content FROM configuration WHERE content_type = ? ORDER BY resource_name", new Object[]{this.type.name()}, (RowMapper)new BonitaConfigurationRowMapper());
        log.debug("configurations found:{}", (Object)bonitaConfigurations);
        return bonitaConfigurations;
    }
}

