/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.bonitasoft.platform.configuration.ConfigurationService;
import org.bonitasoft.platform.configuration.model.BonitaConfiguration;
import org.bonitasoft.platform.configuration.model.FullBonitaConfiguration;
import org.bonitasoft.platform.configuration.model.LightBonitaConfiguration;
import org.bonitasoft.platform.configuration.type.ConfigurationType;
import org.bonitasoft.platform.database.DatabaseVendor;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.ScriptExecutor;
import org.bonitasoft.platform.version.VersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnSingleCandidate(value=PlatformSetup.class)
public class PlatformSetup {
    public static final String BONITA_SETUP_FOLDER = "org.bonitasoft.platform.setup.folder";
    public static final String PLATFORM_CONF_FOLDER_NAME = "platform_conf";
    public static final String BONITA_CLIENT_HOME_FOLDER = "bonita.client.home";
    public static final String BONITA_DB_VENDOR_PROPERTY = "sysprop.bonita.db.vendor";
    public static final String BONITA_BDM_DB_VENDOR_PROPERTY = "sysprop.bonita.bdm.db.vendor";
    protected static final Logger LOGGER = LoggerFactory.getLogger(PlatformSetup.class);
    private final ScriptExecutor scriptExecutor;
    private final ConfigurationService configurationService;
    private final VersionService versionService;
    private final DataSource dataSource;
    protected String dbVendor;
    protected String bdmDbVendor;
    private Path initialConfigurationFolder;
    private Path currentConfigurationFolder;
    private Path backupConfigurationFolder;
    protected Path licensesFolder;
    private Path backupLicensesFolder;
    private final ResourcePatternResolver cpResourceResolver = new PathMatchingResourcePatternResolver(PlatformSetup.class.getClassLoader());

    public PlatformSetup(ScriptExecutor scriptExecutor, ConfigurationService configurationService, VersionService versionService, DataSource dataSource, @Value(value="${db.vendor}") String dbVendor, @Value(value="${bdm.db.vendor}") String bdmDbVendor) {
        this.scriptExecutor = scriptExecutor;
        this.configurationService = configurationService;
        this.versionService = versionService;
        this.dataSource = dataSource;
        this.dbVendor = dbVendor;
        this.bdmDbVendor = bdmDbVendor;
    }

    public static String getPropertyBonitaDbVendor() {
        return System.getProperty(BONITA_DB_VENDOR_PROPERTY);
    }

    public static String getPropertyBonitaBdmDbVendor() {
        return System.getProperty(BONITA_BDM_DB_VENDOR_PROPERTY);
    }

    public void init() throws PlatformException {
        this.initPlatformSetup();
        if (this.isPlatformAlreadyCreated()) {
            LOGGER.info("Platform is already created.");
            if (Files.isDirectory(this.initialConfigurationFolder, new LinkOption[0])) {
                LOGGER.info("Upgrading default configuration with files from folder: {}", (Object)this.initialConfigurationFolder);
                this.updateDefaultConfigurationFromFolder(this.initialConfigurationFolder);
            } else {
                LOGGER.info("Upgrading default configuration with files from classpath");
                this.updateDefaultConfigurationFromClasspath();
            }
            this.insertNewConfigurationsFromClasspathIfExist();
            return;
        }
        this.preventFromPushingZeroLicense();
        this.initializePlatform();
        LOGGER.info("Platform created.");
        if (Files.isDirectory(this.initialConfigurationFolder, new LinkOption[0])) {
            LOGGER.info("Database will be initialized with configuration files from folder: {}", (Object)this.initialConfigurationFolder);
            this.pushFromFolder(this.initialConfigurationFolder);
        } else {
            LOGGER.warn("Database will be initialized with configuration files from classpath");
            this.insertNewConfigurationsFromClasspathIfExist();
        }
        this.pushLicenses(true);
        LOGGER.info("Initial configuration files successfully pushed to database");
    }

    boolean isPlatformAlreadyCreated() {
        return this.scriptExecutor.isPlatformAlreadyCreated();
    }

    private void pushFromFolder(Path folderToPush) throws PlatformException {
        this.configurationService.storeAllConfiguration(folderToPush);
    }

    private void checkPushFolderExists(Path folderToPush) throws PlatformException {
        if (!Files.isDirectory(folderToPush, new LinkOption[0])) {
            throw new PlatformException("Unable to push configuration from " + String.valueOf(folderToPush) + ", as directory does not exists. To modify your configuration, run 'setup pull', update your configuration files from " + String.valueOf(this.currentConfigurationFolder) + " folder, and then push your new configuration.");
        }
    }

    void clean() {
        this.configurationService.deleteAllConfiguration();
    }

    public void push() throws PlatformException {
        this.push(false);
    }

    public void forcePush() throws PlatformException {
        this.push(true);
    }

    public void push(boolean forcePush) throws PlatformException {
        this.initPlatformSetup();
        if (!this.isPlatformAlreadyCreated()) {
            throw new PlatformException("Platform is not created. Run 'setup init' first.");
        }
        this.preventFromPushingZeroLicense();
        this.checkPlatformVersion();
        this.checkPushFolderExists(this.currentConfigurationFolder);
        LOGGER.info("Configuration currently in database will be replaced by configuration from folder: {}", (Object)this.currentConfigurationFolder);
        this.ensureNoCriticalFoldersAreDeleted(forcePush);
        this.pull(this.backupConfigurationFolder, this.backupLicensesFolder);
        LOGGER.info("Backup directory created: {}", (Object)this.backupConfigurationFolder);
        boolean hasLicenses = !this.getConfigurationService().getLicenses().isEmpty();
        this.clean();
        this.pushFromFolder(this.currentConfigurationFolder);
        this.pushLicenses(hasLicenses);
        LOGGER.info("Configuration files successfully pushed to database. You can now restart Bonita to reflect your changes.");
    }

    private void ensureNoCriticalFoldersAreDeleted(boolean forcePush) throws PlatformException {
        List<LightBonitaConfiguration> configurations = this.configurationService.getMandatoryStructureConfiguration();
        for (LightBonitaConfiguration configuration : configurations) {
            Path folder = this.getFolderFromConfiguration(configuration);
            if (Files.isDirectory(folder, new LinkOption[0])) continue;
            if (forcePush) {
                LOGGER.warn("Force-pushing the deletion of folder {}", (Object)folder);
                continue;
            }
            throw new PlatformException("You are trying to remove a protected folder from configuration: " + this.getSpecificErrorMessage(folder));
        }
    }

    protected Path getFolderFromConfiguration(LightBonitaConfiguration configuration) {
        return this.currentConfigurationFolder.resolve(configuration.type().toLowerCase());
    }

    private String getSpecificErrorMessage(Path folder) {
        return "You are not allowed to remove folder '" + folder.toString() + "'" + System.lineSeparator() + "To restore the deleted folders, run 'setup pull'. You will lose the locally modified configuration.";
    }

    public void pull() throws PlatformException {
        this.initPlatformSetup();
        this.checkPlatformVersion();
        LOGGER.info("Pulling configuration into folder: {}", (Object)this.currentConfigurationFolder);
        if (Files.isDirectory(this.licensesFolder, new LinkOption[0])) {
            LOGGER.info("Pulling licenses into folder: {}", (Object)this.licensesFolder);
        }
        this.pull(this.currentConfigurationFolder, this.licensesFolder);
        LOGGER.info("Configuration (and license) files successfully pulled. You can now edit them. Use \"setup push\" when done.");
    }

    public void pull(Path configurationFolder, Path licensesFolder) throws PlatformException {
        try {
            this.recreateDirectory(configurationFolder);
            if (Files.isDirectory(licensesFolder, new LinkOption[0])) {
                FileUtils.cleanDirectory((File)licensesFolder.toFile());
            }
            ArrayList<File> licenses = new ArrayList<File>();
            List<File> files = this.configurationService.writeAllConfigurationToFolder(configurationFolder.toFile(), licensesFolder.toFile());
            LOGGER.info("Retrieved following files in {}", (Object)configurationFolder);
            for (File file : files) {
                if (file.toPath().getParent().equals(licensesFolder)) {
                    licenses.add(file);
                    continue;
                }
                LOGGER.info(configurationFolder.relativize(file.toPath()).toString());
            }
            if (!licenses.isEmpty()) {
                LOGGER.info("Retrieved following licenses in {}", (Object)licensesFolder);
                for (File license : licenses) {
                    LOGGER.info(licensesFolder.relativize(license.toPath()).toString());
                }
            }
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    private void recreateDirectory(Path ... folders) throws IOException {
        for (Path folder : folders) {
            if (Files.exists(folder, new LinkOption[0])) {
                FileUtils.deleteDirectory((File)folder.toFile());
            }
            Files.createDirectories(folder, new FileAttribute[0]);
        }
    }

    private void checkPlatformVersion() throws PlatformException {
        if (!this.versionService.isValidPlatformVersion()) {
            String message = "The version of the platform (binaries) you are running [{0}] only support database schema in version [{1}] but the current database schema version is [{2}]. You might need to migrate your platform or use a different version of the binaries.";
            throw new PlatformException(MessageFormat.format(message, this.versionService.getPlatformSetupVersion(), this.versionService.getSupportedDatabaseSchemaVersion(), this.versionService.retrieveDatabaseSchemaVersion()));
        }
    }

    protected void pushLicenses(boolean hasLicenses) throws PlatformException {
    }

    private void initializePlatform() throws PlatformException {
        this.scriptExecutor.createAndInitializePlatformIfNecessary();
    }

    void initProperties() throws PlatformException {
        Path platformConfFolder;
        if (this.dbVendor == null) {
            this.dbVendor = PlatformSetup.getPropertyBonitaDbVendor();
        }
        this.checkSupportedVendor(this.dbVendor);
        if (this.bdmDbVendor == null) {
            this.bdmDbVendor = PlatformSetup.getPropertyBonitaBdmDbVendor();
        }
        this.checkSupportedVendor(this.bdmDbVendor);
        String setupFolderPath = System.getProperty(BONITA_SETUP_FOLDER);
        if (setupFolderPath != null) {
            LOGGER.info("System property {} is set to {}", (Object)BONITA_SETUP_FOLDER, (Object)setupFolderPath);
            platformConfFolder = Paths.get(setupFolderPath, new String[0]).resolve(PLATFORM_CONF_FOLDER_NAME);
        } else {
            platformConfFolder = Paths.get(PLATFORM_CONF_FOLDER_NAME, new String[0]);
        }
        this.initializeFoldersPaths(platformConfFolder);
    }

    protected void checkSupportedVendor(String databaseVendor) throws PlatformException, IllegalArgumentException {
        DatabaseVendor vendor = DatabaseVendor.parseValue(databaseVendor);
        if (vendor != DatabaseVendor.H2 && vendor != DatabaseVendor.POSTGRES) {
            throw new PlatformException("Database vendor '" + String.valueOf((Object)vendor) + "' is not supported with the community edition");
        }
        LOGGER.debug("Database vendor '{}' is supported", (Object)vendor);
    }

    private void initializeFoldersPaths(Path platformConfFolder) {
        this.initialConfigurationFolder = platformConfFolder.resolve("initial");
        this.currentConfigurationFolder = platformConfFolder.resolve("current");
        Path rootBackupFolder = platformConfFolder.resolve("backup-" + System.currentTimeMillis());
        this.backupConfigurationFolder = rootBackupFolder.resolve("current");
        this.backupLicensesFolder = rootBackupFolder.resolve("licenses");
        this.licensesFolder = this.getLicenseInitialFolder(platformConfFolder);
    }

    private Path getLicenseInitialFolder(Path platformConfFolder) {
        String bonita_client_home = System.getProperty(BONITA_CLIENT_HOME_FOLDER);
        if (bonita_client_home != null) {
            return Paths.get(bonita_client_home, new String[0]);
        }
        return platformConfFolder.resolve("licenses");
    }

    private void updateDefaultConfigurationFromFolder(Path folderToPush) throws PlatformException {
        this.configurationService.updateDefaultConfiguration(folderToPush);
    }

    private void insertNewConfigurationsFromClasspathIfExist() throws PlatformException {
        ArrayList<FullBonitaConfiguration> configurations = new ArrayList<FullBonitaConfiguration>();
        try {
            configurations.addAll(this.getConfigurationsMatchingPattern(ConfigurationType.PLATFORM_ENGINE));
            configurations.addAll(this.getConfigurationsMatchingPattern(ConfigurationType.PLATFORM_PORTAL));
            configurations.addAll(this.getConfigurationsMatchingPattern(ConfigurationType.TENANT_ENGINE));
            configurations.addAll(this.getConfigurationsMatchingPattern(ConfigurationType.TENANT_PORTAL));
            configurations.addAll(this.getConfigurationsMatchingPattern(ConfigurationType.TENANT_SECURITY_SCRIPTS));
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
        this.configurationService.storeConfigurationsIfNotExist(configurations);
    }

    public List<FullBonitaConfiguration> getConfigurationsMatchingPattern(ConfigurationType type) throws IOException {
        Resource[] resources;
        ArrayList<FullBonitaConfiguration> configurations = new ArrayList<FullBonitaConfiguration>();
        String typeLowercase = type.name().toLowerCase();
        for (Resource resource : resources = this.cpResourceResolver.getResources("classpath*:/" + typeLowercase + "/**")) {
            if (!resource.exists() || !resource.isReadable() || resource.contentLength() <= 0L) continue;
            String resourceName = resource.getFilename();
            LOGGER.debug("Found configuration file '{}' of type '{}' in classpath", (Object)resourceName, (Object)type);
            try (InputStream resourceAsStream = resource.getInputStream();){
                byte[] content = IOUtils.toByteArray((InputStream)resourceAsStream);
                configurations.add(new FullBonitaConfiguration(resourceName, content, type.name()));
            }
        }
        return configurations;
    }

    private void updateDefaultConfigurationFromClasspath() throws PlatformException {
        ArrayList<BonitaConfiguration> portalTenant = new ArrayList<BonitaConfiguration>(3);
        try {
            this.addIfExists(portalTenant, ConfigurationType.TENANT_PORTAL, "compound-permissions-mapping.properties");
            this.addIfExists(portalTenant, ConfigurationType.TENANT_PORTAL, "dynamic-permissions-checks.properties");
            this.addIfExists(portalTenant, ConfigurationType.TENANT_PORTAL, "resources-permissions-mapping.properties");
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
        this.configurationService.updateTenantPortalConf(portalTenant);
    }

    private void addIfExists(List<BonitaConfiguration> configurations, ConfigurationType configurationType, String resourceName) throws IOException {
        BonitaConfiguration bonitaConfiguration = this.getBonitaConfigurationFromClassPath(configurationType.name().toLowerCase(), resourceName);
        if (bonitaConfiguration != null) {
            configurations.add(bonitaConfiguration);
        }
    }

    private void initDataSource() throws PlatformException {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseMetaData metaData = connection.getMetaData();
            LOGGER.info("Connected to '{}' database with url: '{}' with user: '{}'", new Object[]{this.dbVendor, metaData.getURL(), metaData.getUserName()});
        }
        catch (SQLException e) {
            throw new PlatformException(e);
        }
    }

    private BonitaConfiguration getBonitaConfigurationFromClassPath(String folder, String resourceName) throws IOException {
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + folder + "/" + resourceName);){
            if (resourceAsStream == null) {
                BonitaConfiguration bonitaConfiguration = null;
                return bonitaConfiguration;
            }
            LOGGER.debug("Using configuration from classpath {}", (Object)resourceName);
            BonitaConfiguration bonitaConfiguration = new BonitaConfiguration(resourceName, IOUtils.toByteArray((InputStream)resourceAsStream));
            return bonitaConfiguration;
        }
    }

    public void destroy() throws PlatformException {
        this.initPlatformSetup();
        if (this.isPlatformAlreadyCreated()) {
            this.scriptExecutor.deleteTables();
        }
    }

    public void initPlatformSetup() throws PlatformException {
        this.initProperties();
        this.initDataSource();
    }

    void preventFromPushingZeroLicense() throws PlatformException {
        String[] licenseFiles;
        if (Files.isDirectory(this.licensesFolder, new LinkOption[0]) && ((licenseFiles = this.licensesFolder.toFile().list((FilenameFilter)new RegexFileFilter(".*\\.lic"))) == null || licenseFiles.length == 0)) {
            throw new PlatformException("No license (.lic file) found." + System.lineSeparator() + "This would prevent Bonita Platform subscription edition to start normally." + System.lineSeparator() + "Place your license file in '" + this.licensesFolder.toAbsolutePath().toString() + "' and then try again.");
        }
    }

    @Generated
    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Generated
    public VersionService getVersionService() {
        return this.versionService;
    }
}

