/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.bonitasoft.platform.configuration.ConfigurationService;
import org.bonitasoft.platform.configuration.impl.ConfigurationServiceImpl;
import org.bonitasoft.platform.setup.PlatformSetup;
import org.bonitasoft.platform.setup.ScriptExecutor;
import org.bonitasoft.platform.version.VersionService;
import org.bonitasoft.platform.version.impl.VersionServiceImpl;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class PlatformSetupAccessor {
    private static final PlatformSetupAccessor _UNIQUE = new PlatformSetupAccessor();
    private PlatformSetup instance;

    protected PlatformSetupAccessor() {
    }

    public static PlatformSetupAccessor getInstance() {
        return _UNIQUE;
    }

    public PlatformSetup getPlatformSetup() throws NamingException {
        if (this.instance == null) {
            this.instance = this.initPlatformSetup();
        }
        return this.instance;
    }

    private PlatformSetup initPlatformSetup() throws NamingException {
        DataSource dataSource = PlatformSetupAccessor.lookupDataSource();
        String dbVendor = PlatformSetup.getPropertyBonitaDbVendor();
        String bdmDbVendor = PlatformSetup.getPropertyBonitaBdmDbVendor();
        return this.createNewPlatformSetup(dataSource, dbVendor, bdmDbVendor);
    }

    public PlatformSetup createNewPlatformSetup(DataSource dataSource, String dbVendor, String bdmDbVendor) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(dataSource);
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)dataSourceTransactionManager);
        VersionServiceImpl versionService = new VersionServiceImpl(jdbcTemplate);
        return this.createPlatformSetup(this.createScriptExecutor(dataSource, dbVendor, versionService), new ConfigurationServiceImpl(jdbcTemplate, transactionTemplate, dbVendor), versionService, dataSource, dbVendor, bdmDbVendor);
    }

    protected PlatformSetup createPlatformSetup(ScriptExecutor scriptExecutor, ConfigurationService configurationService, VersionService versionService, DataSource dataSource, String dbVendor, String bdmDbVendor) {
        return new PlatformSetup(scriptExecutor, configurationService, versionService, dataSource, dbVendor, bdmDbVendor);
    }

    protected ScriptExecutor createScriptExecutor(DataSource dataSource, String dbVendor, VersionService versionService) {
        return new ScriptExecutor(dbVendor, dataSource, versionService);
    }

    private static DataSource lookupDataSource() throws NamingException {
        InitialContext ctx = new InitialContext();
        return (DataSource)ctx.lookup(System.getProperty("sysprop.bonita.database.sequence.manager.datasource.name", "java:comp/env/bonitaSequenceManagerDS"));
    }

    public static ConfigurationService getConfigurationService() throws NamingException {
        DataSource dataSource = PlatformSetupAccessor.lookupDataSource();
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(dataSource);
        TransactionTemplate transactionTemplate = new TransactionTemplate((PlatformTransactionManager)dataSourceTransactionManager);
        return new ConfigurationServiceImpl(jdbcTemplate, transactionTemplate, PlatformSetup.getPropertyBonitaDbVendor());
    }
}

