/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.setup;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import lombok.Generated;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.setup.SimpleEncryptor;
import org.bonitasoft.platform.version.VersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnSingleCandidate(value=ScriptExecutor.class)
@PropertySource(value={"classpath:/application.properties"})
public class ScriptExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptExecutor.class);
    private static final boolean CONTINUE_ON_ERROR = true;
    public static final boolean FAIL_ON_ERROR = false;
    private final String sqlFolder;
    private final DataSource datasource;
    private final String dbVendor;
    private final VersionService versionService;

    @Autowired
    public ScriptExecutor(@Value(value="${db.vendor}") String dbVendor, DataSource datasource, VersionService versionService) {
        if (dbVendor == null) {
            throw new IllegalArgumentException("dbVendor is null");
        }
        this.dbVendor = dbVendor;
        this.datasource = datasource;
        log.info("configuration for Database vendor: {}", (Object)dbVendor);
        this.sqlFolder = "/sql/" + dbVendor;
        this.versionService = versionService;
    }

    public void createTables() throws PlatformException {
        try {
            this.executeSQLResources(Arrays.asList("createTables.sql", "createQuartzTables.sql"), false);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    public void createAndInitializePlatformIfNecessary() throws PlatformException {
        if (!this.isPlatformAlreadyCreated()) {
            this.createTables();
            this.initializePlatformStructure();
            this.insertPlatform();
        } else {
            log.info("Bonita platform already exists. Nothing to do. Stopping.");
        }
    }

    protected void insertPlatform() {
        String version = this.versionService.getPlatformSetupVersion();
        String databaseSchemaVersion = this.versionService.getSupportedDatabaseSchemaVersion();
        String sql = "INSERT INTO platform (id, version, initial_bonita_version, application_version, maintenance_message_active, created, created_by, information, maintenance_enabled) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        new JdbcTemplate(this.datasource).update("INSERT INTO platform (id, version, initial_bonita_version, application_version, maintenance_message_active, created, created_by, information, maintenance_enabled) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)", new Object[]{1L, databaseSchemaVersion, version, "0.0.0", false, System.currentTimeMillis(), "platformAdmin", this.getInformationInitialValue(), false});
    }

    protected String getInformationInitialValue() {
        try {
            return SimpleEncryptor.encrypt(new ObjectMapper().writeValueAsBytes(new ArrayList()));
        }
        catch (JsonProcessingException | GeneralSecurityException e) {
            log.debug(e.getMessage(), e);
            throw new IllegalStateException("Cannot properly setup Bonita platform");
        }
    }

    public boolean isPlatformAlreadyCreated() {
        try {
            return (Integer)new JdbcTemplate(this.datasource).queryForObject("select count(*) from sequence", Integer.class) > 0;
        }
        catch (DataAccessException e) {
            return false;
        }
    }

    protected void executeSQLResources(List<String> sqlFiles, boolean shouldContinueOnError) throws IOException {
        for (String sqlFile : sqlFiles) {
            this.executeSQLResource(sqlFile, shouldContinueOnError);
        }
    }

    private Resource getSQLResource(String sqlFolder, String sqlFile) {
        String setupFolderPath = System.getProperty("org.bonitasoft.platform.setup.folder");
        if (setupFolderPath != null) {
            return this.getResourceFromFileSystem(setupFolderPath, sqlFile);
        }
        return this.getResourceFromClassPath(sqlFolder, sqlFile);
    }

    private Resource getResourceFromFileSystem(String setupFolderPath, String sqlFile) {
        Path path = Paths.get(setupFolderPath, new String[0]).resolve("platform_conf").resolve("sql").resolve(this.dbVendor).resolve(sqlFile);
        File file = path.toFile();
        if (file.exists()) {
            return new FileSystemResource(file);
        }
        String msg = "SQL resource file not found in filesystem: " + file.getAbsolutePath();
        log.error(msg);
        throw new RuntimeException(msg);
    }

    private Resource getResourceFromClassPath(String sqlFolder, String sqlFile) {
        String resourcePath = sqlFolder + "/" + sqlFile;
        URL url = this.getClass().getResource(resourcePath);
        if (url != null) {
            return new UrlResource(url);
        }
        String msg = "SQL resource file not found in classpath: " + resourcePath;
        log.warn(msg);
        throw new RuntimeException(msg);
    }

    protected void executeSQLResource(String sqlFile, boolean shouldContinueOnError) throws IOException {
        Resource sqlResource = this.getSQLResource(this.sqlFolder, sqlFile);
        ResourceDatabasePopulator populate = new ResourceDatabasePopulator();
        populate.setContinueOnError(shouldContinueOnError);
        populate.setIgnoreFailedDrops(true);
        populate.addScript(sqlResource);
        populate.execute(this.datasource);
        log.info("Executed SQL script {}", (Object)sqlResource.getURL().getFile());
    }

    public void initializePlatformStructure() throws PlatformException {
        try {
            this.executeSQLResources(Collections.singletonList("initTables.sql"), false);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    public void deleteTables() throws PlatformException {
        try {
            this.executeSQLResources(Arrays.asList("preDropStructure.sql", "dropQuartzTables.sql", "dropTables.sql"), true);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }
}

