/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.platform.version.impl;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.platform.exception.PlatformException;
import org.bonitasoft.platform.version.VersionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class VersionServiceImpl
implements VersionService {
    private static final String SQL_PLATFORM_VERSION = "SELECT p.version FROM platform p";
    private static final String SQL_PLATFORM_INFORMATION = "SELECT p.information FROM platform p";
    private static final String SQL_CLEAR_PLATFORM_INFORMATION = "UPDATE platform SET information = NULL";
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public VersionServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String retrieveDatabaseSchemaVersion() throws PlatformException {
        List strings;
        try {
            strings = this.jdbcTemplate.queryForList(SQL_PLATFORM_VERSION, String.class);
        }
        catch (DataAccessException e) {
            throw new PlatformException("Platform is not created. Run 'setup init' first.", (Exception)((Object)e));
        }
        if (this.hasNotSingleResult(strings)) {
            throw new PlatformException("Platform is not created. Run 'setup init' first.");
        }
        return (String)strings.get(0);
    }

    @Override
    public String retrievePlatformInformation() throws PlatformException {
        List strings;
        try {
            strings = this.jdbcTemplate.queryForList(SQL_PLATFORM_INFORMATION, String.class);
        }
        catch (DataAccessException e) {
            throw new PlatformException("Platform is not created. Run 'setup init' first.", (Exception)((Object)e));
        }
        if (this.hasNotSingleResult(strings)) {
            throw new PlatformException("Platform is not created. Run 'setup init' first.");
        }
        return (String)strings.get(0);
    }

    @Override
    public void clearPlatformInformation() throws PlatformException {
        try {
            this.jdbcTemplate.execute(SQL_CLEAR_PLATFORM_INFORMATION);
        }
        catch (DataAccessException e) {
            throw new PlatformException("Unable to clear platform information", (Exception)((Object)e));
        }
    }

    private boolean hasNotSingleResult(List<String> strings) {
        return strings == null || strings.size() != 1;
    }

    @Override
    public String getPlatformSetupVersion() {
        return this.getVersionProperty("PLATFORM_ENGINE_VERSION");
    }

    @Override
    public String getSupportedDatabaseSchemaVersion() {
        return this.extractMinorVersion(this.getPlatformSetupVersion());
    }

    private String extractMinorVersion(String version) {
        Matcher matcher = Pattern.compile("(\\d+\\.\\d+).*").matcher(version);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException(version + " does not respect Semantic Versioning");
    }

    private String getVersionProperty(String versionFileName) {
        try {
            return IOUtils.toString((URL)this.getClass().getResource("/" + versionFileName), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException(versionFileName + " file in jar resources does not exists");
        }
    }

    @Override
    public boolean isValidPlatformVersion() throws PlatformException {
        return this.getSupportedDatabaseSchemaVersion().equals(this.retrieveDatabaseSchemaVersion());
    }
}

