/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class FieldValidationRule
extends ValidationRule<Field, ValidationStatus> {
    private static final int MAX_COLUMNAME_LENGTH = 50;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(50);

    public FieldValidationRule() {
        super(Field.class);
    }

    @Override
    public ValidationStatus validate(Field field) {
        ValidationStatus status = new ValidationStatus();
        String name = field.getName();
        if (name == null || !SourceVersion.isIdentifier(name) || SourceVersion.isKeyword(name) || this.isForbiddenIdentifier(name)) {
            status.addError(StatusCode.INVALID_FIELD_IDENTIFIER, String.format("%s is not a valid field identifier", name), Collections.singletonMap("bdmArtifactName", name));
            return status;
        }
        List discouragingGrammars = this.sqlNameValidator.isKeywordDiscouragedBy(name);
        if (!discouragingGrammars.isEmpty()) {
            String msg = String.format("%1$s is discouraged as a field identifier. It is a keyword in %2$s.", name, discouragingGrammars.stream().map(SQLNameValidator.Grammar::toString).collect(Collectors.joining(", ")));
            status.addWarning(StatusCode.DISCOURAGED_FIELD_IDENTIFIER, msg, Collections.singletonMap("bdmArtifactName", name));
        }
        return status;
    }

    private boolean isForbiddenIdentifier(String name) {
        return "persistenceId".equalsIgnoreCase(name) || "persistenceVersion".equalsIgnoreCase(name) || !this.sqlNameValidator.isValid(name);
    }
}

