/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.Index;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class IndexValidationRule
extends ValidationRule<Index, ValidationStatus> {
    private static final int MAX_CONSTRAINTNAME_LENGTH = 25;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(25);

    public IndexValidationRule() {
        super(Index.class);
    }

    @Override
    protected ValidationStatus validate(Index index) {
        ValidationStatus status = new ValidationStatus();
        String name = index.getName();
        if (name == null || name.isEmpty()) {
            status.addError(StatusCode.INDEX_WITHOUT_NAME, "An index must have name");
            return status;
        }
        if (!this.sqlNameValidator.isValid(name)) {
            status.addError(StatusCode.INVALID_SQL_IDENTIFIER_NAME, String.format("%s is not a valid SQL identifier", name), Collections.singletonMap("bdmArtifactName", name));
        } else {
            List discouragingGrammars = this.sqlNameValidator.isKeywordDiscouragedBy(name);
            if (!discouragingGrammars.isEmpty()) {
                String msg = String.format("%1$s is discouraged as an SQL identifier. It is a keyword in %2$s.", name, discouragingGrammars.stream().map(SQLNameValidator.Grammar::toString).collect(Collectors.joining(", ")));
                status.addWarning(StatusCode.DISCOURAGED_SQL_IDENTIFIER_NAME, msg, Collections.singletonMap("bdmArtifactName", name));
            }
        }
        List fieldNames = index.getFieldNames();
        if (fieldNames == null || fieldNames.isEmpty()) {
            status.addError(StatusCode.INDEX_WITHOUT_FIELD, String.format("%s index must have at least one field declared", name), Collections.singletonMap("bdmArtifactName", name));
        }
        return status;
    }
}

