/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.UniqueConstraint;
import org.bonitasoft.engine.bdm.validator.SQLNameValidator;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class UniqueConstraintValidationRule
extends ValidationRule<UniqueConstraint, ValidationStatus> {
    private static final int MAX_CONSTRAINTNAME_LENGTH = 25;
    private final SQLNameValidator sqlNameValidator = new SQLNameValidator(25);

    public UniqueConstraintValidationRule() {
        super(UniqueConstraint.class);
    }

    @Override
    public ValidationStatus validate(UniqueConstraint uc) {
        ValidationStatus status = new ValidationStatus();
        String name = uc.getName();
        if (name == null || name.isEmpty()) {
            status.addError(StatusCode.UNIQUE_CONSTRAINT_WITHOUT_NAME, "A unique constraint must have name");
            return status;
        }
        if (!this.sqlNameValidator.isValid(name)) {
            status.addError(StatusCode.INVALID_SQL_IDENTIFIER_NAME, String.format("%s is not a valid SQL identifier", name), Collections.singletonMap("invalidName", name));
        } else {
            List discouragingGrammars = this.sqlNameValidator.isKeywordDiscouragedBy(name);
            if (!discouragingGrammars.isEmpty()) {
                String msg = String.format("%1$s is discouraged as an SQL identifier. It is a keyword in %2$s.", name, discouragingGrammars.stream().map(SQLNameValidator.Grammar::toString).collect(Collectors.joining(", ")));
                status.addWarning(StatusCode.DISCOURAGED_SQL_IDENTIFIER_NAME, msg, Collections.singletonMap("bdmArtifactName", name));
            }
        }
        List fieldNames = uc.getFieldNames();
        if (fieldNames == null || fieldNames.isEmpty()) {
            status.addError(StatusCode.UNIQUE_CONSTRAINT_WITHOUT_FIELD, String.format("%s unique constraint must have at least one field declared", name), Collections.singletonMap("bdmArtifactName", name));
        }
        return status;
    }
}

