/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule;

import java.util.HashSet;
import java.util.List;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class UniqueSimpleNameValidationRule
extends ValidationRule<BusinessObjectModel, ValidationStatus> {
    public UniqueSimpleNameValidationRule() {
        super(BusinessObjectModel.class);
    }

    @Override
    public ValidationStatus validate(BusinessObjectModel bom) {
        ValidationStatus status = new ValidationStatus();
        List businessObjects = bom.getBusinessObjects();
        HashSet<String> businessObjectNames = new HashSet<String>();
        for (BusinessObject businessObject : businessObjects) {
            if (businessObjectNames.add(businessObject.getSimpleName().toLowerCase())) continue;
            status.addError(StatusCode.DUPLICATE_BUSINESS_OBJECT_NAME, " There are at least 2 objects in the BDM that are called : " + businessObject.getSimpleName());
        }
        return status;
    }
}

