/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule.composition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.model.field.Field;
import org.bonitasoft.engine.bdm.model.field.RelationField;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class AggregationAndCompositionValidationRule
extends ValidationRule<BusinessObjectModel, ValidationStatus> {
    public AggregationAndCompositionValidationRule() {
        super(BusinessObjectModel.class);
    }

    @Override
    protected ValidationStatus validate(BusinessObjectModel bom) {
        ValidationStatus validationStatus = new ValidationStatus();
        List businessObjects = bom.getBusinessObjects();
        ArrayList<BusinessObject> aggregatedBusinessObjects = new ArrayList<BusinessObject>();
        ArrayList composedBusinessObjects = new ArrayList();
        ArrayList fieldList = new ArrayList();
        for (BusinessObject bo : businessObjects) {
            fieldList.addAll(bo.getFields());
        }
        for (Field field : fieldList) {
            RelationField relationField;
            if (!(field instanceof RelationField) || (relationField = (RelationField)field).getType() != RelationField.Type.AGGREGATION) continue;
            aggregatedBusinessObjects.add(relationField.getReference());
        }
        composedBusinessObjects.addAll(bom.getReferencedBusinessObjectsByComposition());
        for (BusinessObject composedBo : composedBusinessObjects) {
            if (!aggregatedBusinessObjects.contains(composedBo)) continue;
            validationStatus.addWarning(StatusCode.BUSINESS_OBJECT_USED_IN_COMPOSITION_AND_AGGREGATION, String.format("The object %s is referenced both in composition and in aggregation. This may lead to runtime errors and may lead to unpredictable behaviour of the AccessControl configuration.", composedBo.getQualifiedName()), Collections.singletonMap("businessObjectName", composedBo.getQualifiedName()));
        }
        return validationStatus;
    }
}

