/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bdm.validator.rule.composition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bonitasoft.engine.api.result.StatusCode;
import org.bonitasoft.engine.bdm.model.BusinessObject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.bdm.validator.ValidationStatus;
import org.bonitasoft.engine.bdm.validator.rule.ValidationRule;

public class CyclicCompositionValidationRule
extends ValidationRule<BusinessObjectModel, ValidationStatus> {
    public CyclicCompositionValidationRule() {
        super(BusinessObjectModel.class);
    }

    @Override
    protected ValidationStatus validate(BusinessObjectModel bom) {
        ValidationStatus validationStatus = new ValidationStatus();
        for (BusinessObject bo : bom.getBusinessObjects()) {
            validationStatus.addValidationStatus(this.validateThatThereIsNoCycleDependencies(bo, new ArrayList<BusinessObject>()));
        }
        return validationStatus;
    }

    private ValidationStatus validateThatThereIsNoCycleDependencies(BusinessObject bo, List<BusinessObject> parentBOs) {
        ValidationStatus validationStatus = new ValidationStatus();
        parentBOs.add(bo);
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("bdmArtifactName", (Serializable)((Object)bo.getQualifiedName()));
        for (BusinessObject businessObject : bo.getReferencedBusinessObjectsByComposition()) {
            if (parentBOs.contains(businessObject)) {
                context.put("businessObjectName", (Serializable)((Object)businessObject.getQualifiedName()));
                validationStatus.addError(StatusCode.CIRCULAR_COMPOSITION_REFERENCE, String.format("Business object %s has a circular composition reference to itself or is referenced several times in the object %s", businessObject.getQualifiedName(), bo.getQualifiedName()), context);
                continue;
            }
            validationStatus.addValidationStatus(this.validateThatThereIsNoCycleDependencies(businessObject, parentBOs));
        }
        return validationStatus;
    }
}

