/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.business.application;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.bonitasoft.engine.business.application.ApplicationField;

class CheckedApplicationFieldMap
implements Map<ApplicationField, Serializable> {
    private final Map<ApplicationField, Serializable> m;
    private final Predicate<ApplicationField> isValidKey;

    CheckedApplicationFieldMap(Map<ApplicationField, Serializable> m, Predicate<ApplicationField> isValidKey) {
        this.m = Objects.requireNonNull(m);
        this.isValidKey = Objects.requireNonNull(isValidKey);
    }

    private ApplicationField checkKey(ApplicationField key) {
        if (!this.isValidKey.test(key)) {
            throw new IllegalArgumentException(MessageFormat.format("Attempt to insert {0} in a specialized map which does not support it.", key.name()));
        }
        return key;
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.m.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.m.containsValue(value);
    }

    @Override
    public Serializable get(Object key) {
        return this.m.get(key);
    }

    @Override
    public Serializable put(ApplicationField key, Serializable value) {
        return this.m.put(this.checkKey(key), value);
    }

    @Override
    public Serializable remove(Object key) {
        return this.m.remove(key);
    }

    @Override
    public void putAll(Map<? extends ApplicationField, ? extends Serializable> map) {
        map.keySet().forEach(this::checkKey);
        this.m.putAll(map);
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public Set<ApplicationField> keySet() {
        return this.m.keySet();
    }

    @Override
    public Collection<Serializable> values() {
        return this.m.values();
    }

    @Override
    public Set<Map.Entry<ApplicationField, Serializable>> entrySet() {
        return this.m.entrySet();
    }
}

