/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.filter;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.api.APIAccessor;
import org.bonitasoft.engine.connector.ConnectorValidationException;
import org.bonitasoft.engine.connector.EngineExecutionContext;
import org.bonitasoft.engine.filter.UserFilter;

public abstract class AbstractUserFilter
implements UserFilter {
    private final Map<String, Object> inputParameters = new HashMap<String, Object>();
    private APIAccessor apiAccessor;
    private EngineExecutionContext executionContext;

    @Override
    public void setInputParameters(Map<String, Object> parameters) {
        this.inputParameters.putAll(parameters);
    }

    protected Object getInputParameter(String paramName) throws IllegalStateException {
        return this.inputParameters.get(paramName);
    }

    protected <T> T getOptinalInputParameter(String paramName) {
        return (T)this.inputParameters.get(paramName);
    }

    protected String getStringInputParameter(String paramName) {
        return (String)this.getInputParameter(paramName);
    }

    protected void validateStringInputParameterIsNotNulOrEmpty(String paramName) throws ConnectorValidationException {
        String paramValue = (String)this.getInputParameter(paramName);
        if (paramValue == null || "".equals(paramValue.trim())) {
            throw new ConnectorValidationException("The input parameter '" + paramName + "' cannot be null or empty");
        }
    }

    @Override
    public boolean shouldAutoAssignTaskIfSingleResult() {
        return true;
    }

    public void setAPIAccessor(APIAccessor apiAccessor) {
        this.apiAccessor = apiAccessor;
    }

    public void setExecutionContext(EngineExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public APIAccessor getAPIAccessor() {
        return this.apiAccessor;
    }

    public EngineExecutionContext getExecutionContext() {
        return this.executionContext;
    }
}

