/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bonitasoft.engine.identity.ContactDataUpdater;

public class UserUpdater
implements Serializable {
    private static final long serialVersionUID = 4565052647320534796L;
    private final Map<UserField, Serializable> fields = new HashMap<UserField, Serializable>(5);
    private ContactDataUpdater persoContactUpdater;
    private ContactDataUpdater proContactUpdater;

    public UserUpdater setUserName(String name) {
        this.fields.put(UserField.USER_NAME, (Serializable)((Object)name));
        return this;
    }

    public UserUpdater setPassword(String password) {
        this.fields.put(UserField.PASSWORD, (Serializable)((Object)password));
        return this;
    }

    public UserUpdater setFirstName(String firstName) {
        this.fields.put(UserField.FIRST_NAME, (Serializable)((Object)firstName));
        return this;
    }

    public UserUpdater setLastName(String lastName) {
        this.fields.put(UserField.LAST_NAME, (Serializable)((Object)lastName));
        return this;
    }

    @Deprecated
    public UserUpdater setIconName(String iconName) {
        return this;
    }

    public UserUpdater setManagerId(long managerId) {
        this.fields.put(UserField.MANAGER_ID, Long.valueOf(managerId));
        return this;
    }

    @Deprecated
    public UserUpdater setIconPath(String iconPath) {
        return this;
    }

    public UserUpdater setTitle(String title) {
        this.fields.put(UserField.TITLE, (Serializable)((Object)title));
        return this;
    }

    public UserUpdater setJobTitle(String jobTitle) {
        this.fields.put(UserField.JOB_TITLE, (Serializable)((Object)jobTitle));
        return this;
    }

    public UserUpdater setEnabled(boolean enabled) {
        this.fields.put(UserField.ENABLED, Boolean.valueOf(enabled));
        return this;
    }

    public Map<UserField, Serializable> getFields() {
        return this.fields;
    }

    public UserUpdater setPersonalContactData(ContactDataUpdater persoContactUpdater) {
        this.persoContactUpdater = persoContactUpdater;
        return this;
    }

    public UserUpdater setProfessionalContactData(ContactDataUpdater proContactUpdater) {
        this.proContactUpdater = proContactUpdater;
        return this;
    }

    public ContactDataUpdater getPersoContactUpdater() {
        return this.persoContactUpdater;
    }

    public ContactDataUpdater getProContactUpdater() {
        return this.proContactUpdater;
    }

    public boolean hasFields() {
        return !this.getFields().isEmpty() || this.getPersoContactUpdater() != null && this.getPersoContactUpdater().hasFields() || this.getProContactUpdater() != null && this.getProContactUpdater().hasFields();
    }

    public UserUpdater setIcon(String filename, byte[] content) {
        this.fields.put(UserField.ICON_FILENAME, (Serializable)((Object)filename));
        this.fields.put(UserField.ICON_CONTENT, (Serializable)content);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserUpdater that = (UserUpdater)o;
        return Objects.equals(this.fields, that.fields) && Objects.equals(this.persoContactUpdater, that.persoContactUpdater) && Objects.equals(this.proContactUpdater, that.proContactUpdater);
    }

    public int hashCode() {
        return Objects.hash(this.fields, this.persoContactUpdater, this.proContactUpdater);
    }

    public String toString() {
        return "UserUpdater{fields=" + String.valueOf(this.fields) + ", persoContactUpdater=" + String.valueOf(this.persoContactUpdater) + ", proContactUpdater=" + String.valueOf(this.proContactUpdater) + "}";
    }

    public static enum UserField {
        USER_NAME,
        PASSWORD,
        FIRST_NAME,
        LAST_NAME,
        ICON_NAME,
        ICON_PATH,
        TITLE,
        JOB_TITLE,
        MANAGER_ID,
        ENABLED,
        ICON_FILENAME,
        ICON_CONTENT;

    }
}

